/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.components;

import com.hand.hap.activiti.dto.HiIdentitylink;
import com.hand.hap.activiti.listeners.TaskCreateNotificationListener;
import com.hand.hap.activiti.mapper.HiIdentitylinkMapper;
import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.QueueMonitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.db.DbSqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@QueueMonitor(queue="wfl.carbon.copy")
public class WflCarbonCopyManager
implements IMessageConsumer<Map> {
    @Autowired
    private TaskCreateNotificationListener taskCreateNotificationListener;
    @Autowired
    private DbSqlSessionFactory dbSqlSessionFactory;
    @Autowired
    private HiIdentitylinkMapper hiIdentitylinkMapper;
    @Autowired
    private TaskService taskService;

    @Override
    public void onMessage(Map message, String pattern) {
        String processInstanceId = message.get("processInstanceId").toString();
        List users = (List)message.get("users");
        HashMap params = new HashMap();
        users.forEach(t -> {
            HiIdentitylink identitylink = new HiIdentitylink();
            identitylink.setProcInstId_(processInstanceId);
            identitylink.setUserId_((String)t);
            identitylink.setType_("carbonCopy");
            int size = this.hiIdentitylinkMapper.select(identitylink).size();
            if (size > 0) {
                identitylink.setReadFlag_("N");
                this.hiIdentitylinkMapper.updateReadFlag(identitylink);
            } else {
                String id = this.dbSqlSessionFactory.getIdGenerator().getNextId();
                params.put("id", id);
                params.put("userId", t);
                params.put("type", "carbonCopy");
                params.put("processInstanceId", processInstanceId);
                this.hiIdentitylinkMapper.insertCarbonCopy(params);
            }
            this.taskCreateNotificationListener.sendMessageForCC((String)t);
            params.clear();
        });
    }
}

