/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.components;

import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.TopicMonitor;
import com.hand.hap.system.dto.Prompt;
import com.hand.hap.system.mapper.PromptMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@TopicMonitor(channel={"cache.prompt"})
public class DefaultPromptListener
implements IMessageConsumer<String>,
InitializingBean {
    public static final String CACHE_PROMPT = "cache.prompt";
    public static final String SYS_PROMPT = "hap.";
    @Autowired
    private PromptMapper promptMapper;
    private Map<String, List<Prompt>> promptsMap = new HashMap<String, List<Prompt>>();

    @Override
    public void onMessage(String message, String pattern) {
        if (message.toLowerCase().startsWith(SYS_PROMPT)) {
            this.reload();
        }
    }

    private void reload() {
        Prompt p = new Prompt();
        p.setPromptCode(SYS_PROMPT);
        List<Prompt> prompts = this.promptMapper.select(p);
        HashMap<String, List<Prompt>> promptsMapNew = new HashMap<String, List<Prompt>>(16);
        for (Prompt prompt : prompts) {
            ArrayList<Prompt> list = (ArrayList<Prompt>)promptsMapNew.get(prompt.getLang());
            if (list == null) {
                list = new ArrayList<Prompt>();
                promptsMapNew.put(prompt.getLang(), list);
            }
            list.add(prompt);
        }
        this.promptsMap = promptsMapNew;
    }

    public List<Prompt> getDefaultPrompt(String lang) {
        List<Prompt> prompts = this.promptsMap.get(lang);
        if (prompts == null || prompts.isEmpty()) {
            this.reload();
            prompts = this.promptsMap.get(lang);
        }
        return prompts;
    }

    public void afterPropertiesSet() throws Exception {
        this.reload();
    }
}

