/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message;

import com.hand.hap.core.AppContextInitListener;
import com.hand.hap.message.ITopicMessageListener;
import com.hand.hap.message.MethodReflectUtils;
import com.hand.hap.message.TopicMonitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.RedisSerializer;

public class TopicMessageListenerRegister
extends HashMap<MessageListener, Collection<? extends Topic>>
implements AppContextInitListener {
    private List<ITopicMessageListener> listeners;
    @Autowired
    private ApplicationContext applicationContext;
    private Logger logger = LoggerFactory.getLogger(TopicMessageListenerRegister.class);

    public List<ITopicMessageListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<ITopicMessageListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void contextInitialized(ApplicationContext applicationContext) {
        Map monitors = applicationContext.getBeansWithAnnotation(TopicMonitor.class);
        monitors.forEach((k, v) -> {
            TopicMonitor tm;
            String mn;
            Class<?> clazz = v.getClass();
            List<Method> avaMethods = MethodReflectUtils.findMethod(clazz, new MethodReflectUtils.FindDesc(mn = MethodReflectUtils.getTopicMethodName((tm = clazz.getAnnotation(TopicMonitor.class)).method(), v), 2));
            if (avaMethods.isEmpty()) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("can not find proper method of name '{}' for bean {}", (Object)mn, v);
                }
                return;
            }
            SimpleMessageListener adaptor = new SimpleMessageListener(v, avaMethods.get(0));
            ArrayList<PatternTopic> topics = new ArrayList<PatternTopic>();
            for (String t : tm.channel()) {
                PatternTopic topic = new PatternTopic(t);
                topics.add(topic);
            }
            this.put(adaptor, topics);
        });
        if (this.listeners != null) {
            for (ITopicMessageListener receiver : this.listeners) {
                MessageListenerAdapter messageListener = new MessageListenerAdapter((Object)receiver, "onTopicMessage");
                if (receiver.getRedisSerializer() != null) {
                    messageListener.setSerializer(receiver.getRedisSerializer());
                }
                messageListener.afterPropertiesSet();
                ArrayList<PatternTopic> topics = new ArrayList<PatternTopic>();
                for (String t : receiver.getTopic()) {
                    PatternTopic topic = new PatternTopic(t);
                    topics.add(topic);
                }
                this.put(messageListener, topics);
            }
        }
    }

    private static class SimpleMessageListener
    implements MessageListener {
        private RedisSerializer redisSerializer;
        private Object target;
        private Method method;
        private Logger logger;

        SimpleMessageListener(Object target, Method method) {
            this.target = target;
            this.method = method;
            Class<?> p0 = method.getParameterTypes()[0];
            this.redisSerializer = MethodReflectUtils.getProperRedisSerializer(p0);
            this.logger = LoggerFactory.getLogger(target.getClass());
        }

        public void onMessage(Message message, byte[] pattern) {
            block3: {
                try {
                    Object obj = this.redisSerializer.deserialize(message.getBody());
                    String p = new String(pattern, "UTF-8");
                    this.method.invoke(this.target, obj, p);
                }
                catch (Exception e) {
                    Throwable thr = e;
                    while (thr.getCause() != null) {
                        thr = thr.getCause();
                    }
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error(thr.getMessage(), thr);
                }
            }
        }
    }
}

