/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.cache.impl.MessageTemplateCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.EmailException;
import com.hand.hap.mail.dto.MessageTemplate;
import com.hand.hap.mail.mapper.MessageTemplateMapper;
import com.hand.hap.mail.service.IMessageTemplateService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageTemplateServiceImpl
extends BaseServiceImpl<MessageTemplate>
implements IMessageTemplateService {
    @Autowired
    private MessageTemplateMapper templateMapper;
    @Autowired
    private MessageTemplateCache templateCache;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MessageTemplate createMessageTemplate(IRequest request, MessageTemplate obj) throws EmailException {
        if (obj == null) {
            return null;
        }
        this.templateMapper.insertSelective(obj);
        this.templateCache.reload(obj.getTemplateCode());
        return obj;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MessageTemplate updateMessageTemplate(IRequest request, MessageTemplate obj) throws EmailException {
        if (obj == null) {
            return null;
        }
        int updateCount = this.templateMapper.updateByPrimaryKeySelective(obj);
        this.checkOvn(updateCount, obj);
        this.templateCache.reload(obj.getTemplateCode());
        return obj;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public MessageTemplate selectMessageTemplateById(IRequest request, Long objId) {
        if (objId == null) {
            return null;
        }
        return (MessageTemplate)this.templateMapper.selectByPrimaryKey(objId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteMessageTemplate(IRequest request, MessageTemplate obj) {
        if (obj.getTemplateId() == null) {
            return 0;
        }
        int result = this.templateMapper.deleteByPrimaryKey(obj);
        this.checkOvn(result, obj);
        this.templateCache.reload(obj.getTemplateCode());
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(IRequest request, List<MessageTemplate> objs) {
        int result = 0;
        if (CollectionUtils.isEmpty(objs)) {
            return result;
        }
        for (MessageTemplate obj : objs) {
            ((IMessageTemplateService)this.self()).deleteMessageTemplate(request, obj);
            ++result;
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MessageTemplate> selectMessageTemplates(IRequest request, MessageTemplate example, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return this.templateMapper.selectMessageTemplates(example);
    }
}

