/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.cache.impl.MessageEmailConfigCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.EmailException;
import com.hand.hap.mail.dto.MessageEmailAccount;
import com.hand.hap.mail.dto.MessageEmailConfig;
import com.hand.hap.mail.dto.MessageEmailProperty;
import com.hand.hap.mail.dto.MessageEmailWhiteList;
import com.hand.hap.mail.mapper.MessageEmailAccountMapper;
import com.hand.hap.mail.mapper.MessageEmailConfigMapper;
import com.hand.hap.mail.mapper.MessageEmailPropertyMapper;
import com.hand.hap.mail.mapper.MessageEmailWhiteListMapper;
import com.hand.hap.mail.service.IMessageEmailConfigService;
import com.hand.hap.security.service.IAESClientService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageEmailConfigServiceImpl
extends BaseServiceImpl<MessageEmailConfig>
implements IMessageEmailConfigService,
BeanFactoryAware {
    public static final String MSG_MESSAGE_NO_WHITE_LIST = "msg.warning.system.email_message_no_whitelist";
    public static final String MSG_MESSAGE_NO_ACCOUNT_LIST = "msg.warning.system.email_message_on_accountlist";
    private BeanFactory beanFactory;
    @Autowired
    private MessageEmailConfigMapper mapper;
    @Autowired
    private MessageEmailAccountMapper accountMapper;
    @Autowired
    private MessageEmailWhiteListMapper addressMapper;
    @Autowired
    private MessageEmailPropertyMapper messageEmailPropertyMapper;
    @Autowired
    private IAESClientService aceClientService;
    @Autowired
    private MessageEmailConfigCache configCache;

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MessageEmailConfig createMessageEmailConfig(IRequest request, MessageEmailConfig obj) {
        if (obj == null) {
            return null;
        }
        obj.setPassword(this.aceClientService.encrypt(obj.getPassword()));
        this.mapper.insertSelective(obj);
        return obj;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MessageEmailConfig updateMessageEmailConfig(IRequest request, MessageEmailConfig obj) {
        if (obj == null) {
            return null;
        }
        MessageEmailConfig config = (MessageEmailConfig)this.mapper.selectByPrimaryKey(obj.getConfigId());
        if (config != null) {
            if (config.getPassword() != null && config.getPassword().equals(obj.getPassword())) {
                obj.setPassword(null);
            } else {
                obj.setPassword(this.aceClientService.encrypt(obj.getPassword()));
            }
        }
        int updateCount = this.mapper.updateByPrimaryKeySelective(obj);
        this.checkOvn(updateCount, obj);
        return obj;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public MessageEmailConfig selectMessageEmailConfigById(IRequest request, Long objId) {
        if (objId == null) {
            return null;
        }
        return (MessageEmailConfig)this.mapper.selectByPrimaryKey(objId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int deleteMessageEmailConfig(IRequest request, MessageEmailConfig obj) {
        if (obj.getConfigId() == null) {
            return 0;
        }
        this.accountMapper.deleteByConfigId(obj.getConfigId());
        this.addressMapper.deleteByConfigId(obj.getConfigId());
        this.messageEmailPropertyMapper.deleteByConfigId(obj.getConfigId());
        int updateCount = this.mapper.deleteByPrimaryKey(obj);
        this.checkOvn(updateCount, obj);
        this.configCache.remove(obj.getConfigId());
        return updateCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(IRequest request, List<MessageEmailConfig> objs) {
        int result = 0;
        if (CollectionUtils.isEmpty(objs)) {
            return result;
        }
        for (MessageEmailConfig obj : objs) {
            ((IMessageEmailConfigService)this.self()).deleteMessageEmailConfig(request, obj);
            ++result;
        }
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MessageEmailConfig> selectMessageEmailConfigs(IRequest request, MessageEmailConfig example, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return this.mapper.selectMessageEmailConfigs(example);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdate(IRequest requestContext, MessageEmailConfig obj) throws EmailException {
        if (obj != null) {
            if (CollectionUtils.isEmpty(obj.getEmailAccounts())) {
                throw new EmailException(MSG_MESSAGE_NO_ACCOUNT_LIST);
            }
            if ("Y".equalsIgnoreCase(obj.getUseWhiteList()) && CollectionUtils.isEmpty(obj.getWhiteLists())) {
                throw new EmailException(MSG_MESSAGE_NO_WHITE_LIST);
            }
            if (obj.getConfigId() == null) {
                this.createMessageEmailConfig(requestContext, obj);
            } else {
                this.updateMessageEmailConfig(requestContext, obj);
            }
            if (obj.getEmailAccounts() != null) {
                for (MessageEmailAccount messageEmailAccount : obj.getEmailAccounts()) {
                    if (messageEmailAccount.getAccountId() == null) {
                        messageEmailAccount.setObjectVersionNumber(0L);
                        messageEmailAccount.setConfigId(obj.getConfigId());
                        this.createEmailAccount(requestContext, messageEmailAccount);
                        continue;
                    }
                    this.updateEmailAccount(requestContext, messageEmailAccount);
                }
            }
            if (obj.getWhiteLists() != null) {
                for (MessageEmailWhiteList messageEmailWhiteList : obj.getWhiteLists()) {
                    if (messageEmailWhiteList.getId() == null) {
                        messageEmailWhiteList.setObjectVersionNumber(0L);
                        messageEmailWhiteList.setConfigId(obj.getConfigId());
                        this.createAddress(requestContext, messageEmailWhiteList);
                        continue;
                    }
                    this.updateAddress(requestContext, messageEmailWhiteList);
                }
            }
            if (obj.getPropertyLists() != null) {
                for (MessageEmailProperty messageEmailProperty : obj.getPropertyLists()) {
                    if (messageEmailProperty.getPropertyId() == null) {
                        messageEmailProperty.setObjectVersionNumber(0L);
                        messageEmailProperty.setConfigId(obj.getConfigId());
                        this.createProperty(requestContext, messageEmailProperty);
                        continue;
                    }
                    this.updateProperty(requestContext, messageEmailProperty);
                }
            }
        }
        this.configCache.reload(obj.getConfigId());
    }

    private MessageEmailAccount createEmailAccount(IRequest request, MessageEmailAccount obj) {
        if (obj == null) {
            return null;
        }
        this.accountMapper.insertSelective(obj);
        return obj;
    }

    private MessageEmailWhiteList createAddress(IRequest request, MessageEmailWhiteList obj) {
        if (obj == null) {
            return null;
        }
        this.addressMapper.insertSelective(obj);
        return obj;
    }

    private MessageEmailAccount updateEmailAccount(IRequest request, MessageEmailAccount obj) {
        if (obj == null) {
            return null;
        }
        int updateCount = this.accountMapper.updateByPrimaryKeySelective(obj);
        this.checkOvn(updateCount, obj);
        return obj;
    }

    private MessageEmailWhiteList updateAddress(IRequest request, MessageEmailWhiteList obj) {
        if (obj == null) {
            return null;
        }
        int updateCount = this.addressMapper.updateByPrimaryKeySelective(obj);
        this.checkOvn(updateCount, obj);
        return obj;
    }

    private MessageEmailProperty createProperty(IRequest request, MessageEmailProperty obj) {
        if (obj == null) {
            return null;
        }
        this.messageEmailPropertyMapper.insertSelective(obj);
        return obj;
    }

    private MessageEmailProperty updateProperty(IRequest request, MessageEmailProperty obj) {
        if (obj == null) {
            return null;
        }
        int updateCount = this.messageEmailPropertyMapper.updateByPrimaryKeySelective(obj);
        this.checkOvn(updateCount, obj);
        return obj;
    }
}

