/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.lock.impl;

import com.hand.hap.lock.DistributedLockCallback;
import com.hand.hap.lock.DistributedLockProvider;
import com.hand.hap.lock.exception.LockException;
import com.hand.hap.lock.util.LockKeyUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonRedLock;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleDistributedLockProvider
implements DistributedLockProvider {
    private static final Logger logger = LoggerFactory.getLogger(MultipleDistributedLockProvider.class);
    private static final long DEFAULT_TIMEOUT = 600L;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    private static final long DEFAULT_WAIT_TIME = 1L;
    private List<RedissonClient> redissons;

    public MultipleDistributedLockProvider() {
    }

    public MultipleDistributedLockProvider(List<RedissonClient> redissons) {
        this.redissons = redissons;
    }

    @Override
    public <T> T lock(String lockKey, DistributedLockCallback<T> callback) {
        return this.lock(lockKey, callback, 600L, DEFAULT_TIME_UNIT);
    }

    @Override
    public <T> T lock(Object lockKey, DistributedLockCallback<T> callback) {
        return this.lock(LockKeyUtil.getLockKey(lockKey), callback, 600L, DEFAULT_TIME_UNIT);
    }

    @Override
    public <T> T lock(Object lockKey, DistributedLockCallback<T> callback, long leaseTime, TimeUnit timeUnit) {
        return this.lock(LockKeyUtil.getLockKey(lockKey), callback, leaseTime, timeUnit);
    }

    @Override
    public <T> T lock(String lockKey, DistributedLockCallback<T> callback, long leaseTime, TimeUnit timeUnit) {
        RedissonRedLock lock = null;
        try {
            lock = new RedissonRedLock(this.getRlocks(lockKey));
            lock.lock(leaseTime, timeUnit);
            T t = callback.process();
            return t;
        }
        catch (Exception e) {
            logger.error("callback  process error", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    @Override
    public <T> T tryLock(String lockKey, DistributedLockCallback<T> callback) throws Exception {
        return this.tryLock(lockKey, callback, 1L, 600L, DEFAULT_TIME_UNIT);
    }

    @Override
    public <T> T tryLock(Object lockKey, DistributedLockCallback<T> callback) throws Exception {
        return this.tryLock(LockKeyUtil.getLockKey(lockKey), callback, 1L, 600L, DEFAULT_TIME_UNIT);
    }

    @Override
    public <T> T tryLock(Object lockKey, DistributedLockCallback<T> callback, long waitTime, long leaseTime, TimeUnit timeUnit) throws Exception {
        return this.tryLock(LockKeyUtil.getLockKey(lockKey), callback, waitTime, leaseTime, timeUnit);
    }

    @Override
    public <T> T tryLock(String lockKey, DistributedLockCallback<T> callback, long waitTime, long leaseTime, TimeUnit timeUnit) throws Exception {
        RedissonRedLock lock = null;
        try {
            lock = new RedissonRedLock(this.getRlocks(lockKey));
            if (lock.tryLock(waitTime, leaseTime, timeUnit)) {
                T t = callback.process();
                return t;
            }
            throw new LockException("tryLock failure", null);
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    public void setRedisson(List<RedissonClient> redissons) {
        this.redissons = redissons;
    }

    private RLock[] getRlocks(String lockKey) {
        RLock[] rLock = new RLock[this.redissons.size()];
        for (int i = 0; i < this.redissons.size(); ++i) {
            RedissonClient redisson = this.redissons.get(i);
            rLock[i] = redisson.getLock(lockKey);
        }
        return rLock;
    }
}

