/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.lock.impl;

import com.hand.hap.lock.DistributedLockProvider;
import com.hand.hap.lock.impl.MultipleDistributedLockProvider;
import com.hand.hap.mybatis.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.Assert;

public class DistributedLockFactoryBean
implements FactoryBean<DistributedLockProvider> {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLockFactoryBean.class);
    private LockInstanceMode mode;
    private DistributedLockProvider distributedLockProvider;
    private List<RedissonClient> redissons;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        logger.debug("init template");
        Properties pro = new Properties();
        InputStream inputStream = null;
        Config config = null;
        List<String> urls = null;
        List<String> passwords = null;
        try {
            inputStream = DistributedLockFactoryBean.class.getClassLoader().getResourceAsStream("config.properties");
            pro.load(inputStream);
            urls = this.getArray(pro.getProperty("redisson.server.url"));
            passwords = this.getArray(pro.getProperty("redissson.server.password"));
        }
        catch (IOException e) {
            logger.error("load config.properties failure", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        this.redissons = new ArrayList<RedissonClient>();
        for (int i = 0; i < urls.size(); ++i) {
            String url = urls.get(i);
            String password = null;
            if (passwords != null && passwords.size() > i) {
                password = passwords.get(i);
            }
            config = new Config();
            if (StringUtil.isNotEmpty(password)) {
                config.useSingleServer().setAddress(url).setPassword(password);
            } else {
                config.useSingleServer().setAddress(url);
            }
            Assert.notNull((Object)config, (String)"config can not be null");
            this.redissons.add(Redisson.create((Config)config));
        }
    }

    @PreDestroy
    public void destroy() {
        logger.debug("destory template");
        for (RedissonClient redisson : this.redissons) {
            redisson.shutdown();
        }
    }

    public DistributedLockProvider getObject() throws Exception {
        switch (this.mode) {
            case MULTIPLE: {
                if (this.redissons == null || this.redissons.size() <= 0) break;
                this.distributedLockProvider = new MultipleDistributedLockProvider(this.redissons);
            }
        }
        return this.distributedLockProvider;
    }

    public Class<?> getObjectType() {
        return DistributedLockProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setMode(String mode) {
        if (StringUtils.isBlank((CharSequence)mode)) {
            throw new IllegalArgumentException("Can't Find mode");
        }
        this.mode = LockInstanceMode.parse(mode);
        if (this.mode == null) {
            throw new IllegalArgumentException("Not Support Mode");
        }
    }

    private List<String> getArray(String str) {
        ArrayList<String> results = new ArrayList<String>();
        if (StringUtil.isNotEmpty(str)) {
            String[] strArray;
            for (String s : strArray = str.split(",")) {
                if (!StringUtil.isNotEmpty(s)) continue;
                results.add(s);
            }
        }
        return results;
    }

    private static enum LockInstanceMode {
        MULTIPLE;


        public static LockInstanceMode parse(String name) {
            for (LockInstanceMode modeIns : LockInstanceMode.values()) {
                if (!modeIns.name().equals(name.toUpperCase())) continue;
                return modeIns;
            }
            return null;
        }
    }
}

