/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.job.examples;

import com.hand.hap.job.AbstractJob;
import java.util.Date;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class BadJob1
extends AbstractJob {
    private static Logger log = LoggerFactory.getLogger(BadJob1.class);
    private int calculation;

    @Override
    public void safeExecute(JobExecutionContext context) throws Exception {
        JobKey jobKey = context.getJobDetail().getKey();
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        int denominator = dataMap.getInt("denominator");
        log.info("---" + jobKey + " executing at " + new Date() + " with denominator " + denominator);
        try {
            this.calculation = 4815 / denominator;
        }
        catch (Exception e) {
            dataMap.put("denominator", "1");
            throw e;
        }
        log.info("---" + jobKey + " completed at " + new Date());
    }

    @Override
    public boolean isRefireImmediatelyWhenException() {
        return true;
    }
}

