/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.aop;

import com.hand.hap.core.interceptor.MonitorInterceptor;
import com.hand.hap.intergration.annotation.HapInbound;
import com.hand.hap.intergration.beans.HapinterfaceBound;
import com.hand.hap.intergration.dto.HapInterfaceInbound;
import com.hand.hap.intergration.util.HapInvokeLogUtils;
import com.hand.hap.message.IMessagePublisher;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;

@Aspect
@Component
public class HapInvokeExceptionAspect {
    @Autowired
    private IMessagePublisher messagePublisher;
    private static final Logger logger = LoggerFactory.getLogger(HapInvokeExceptionAspect.class);

    @Before(value="@annotation(exceptionHander)")
    public void beforeMethod(JoinPoint joinpoint, ExceptionHandler exceptionHander) {
        HandlerMethod handler = (HandlerMethod)MonitorInterceptor.REST_INVOKE_HANDLER.get();
        if (handler == null) {
            return;
        }
        Method method = handler.getMethod();
        HapInbound hapInbound = method.getAnnotation(HapInbound.class);
        if (hapInbound != null) {
            Object[] parms;
            Exception e = null;
            for (Object obj : parms = joinpoint.getArgs()) {
                if (!(obj instanceof Exception)) continue;
                e = (Exception)obj;
            }
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HapInterfaceInbound inbound = new HapInterfaceInbound();
            inbound.setInterfaceName(hapInbound.apiName());
            inbound.setRequestTime(new Date());
            inbound.setRequestStatus("failure");
            inbound.setResponseTime(0L);
            HapInvokeLogUtils.processRequestInfo(inbound, request);
            HapInvokeLogUtils.processExceptionInfo(inbound, (Throwable)e);
            HapinterfaceBound bound = new HapinterfaceBound(inbound);
            this.messagePublisher.message("invoke.inbound", bound);
        }
    }
}

