/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.service.impl;

import com.hand.hap.cache.impl.RoleFunctionCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.function.dto.RoleFunction;
import com.hand.hap.function.mapper.RoleFunctionMapper;
import com.hand.hap.function.service.IRoleFunctionService;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleFunctionServiceImpl
extends BaseServiceImpl<RoleFunction>
implements IRoleFunctionService {
    @Autowired
    private RoleFunctionMapper rolefunctionMapper;
    @Autowired
    private RoleFunctionCache roleFunctionCache;
    @Autowired
    private IMessagePublisher messagePublisher;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public Long[] getRoleFunctionById(Long roleId) {
        Long[] roleFuction = this.roleFunctionCache.getValue(roleId.toString());
        if (roleFuction == null) {
            this.roleFunctionCache.reload();
            return this.roleFunctionCache.getValue(roleId.toString());
        }
        return roleFuction;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<RoleFunction> batchUpdate(IRequest requestContext, List<RoleFunction> roleFunctions) {
        if (CollectionUtils.isNotEmpty(roleFunctions)) {
            RoleFunction rf = roleFunctions.get(0);
            Object[] ids = new Long[roleFunctions.size()];
            Long roleId = rf.getRoleId();
            int i = 0;
            this.rolefunctionMapper.deleteByRoleId(roleId);
            for (RoleFunction rolefunction : roleFunctions) {
                if (rolefunction.getFunctionId() != null) {
                    this.rolefunctionMapper.insertSelective(rolefunction);
                    ids[i++] = rolefunction.getFunctionId();
                    continue;
                }
                ids = null;
            }
            this.removeCache(roleId);
            if (ArrayUtils.isNotEmpty((Object[])ids)) {
                this.roleFunctionCache.setValue(roleId.toString(), (Long[])ids);
                ((IRoleFunctionService)this.self()).reloadRoleResourceCache(roleId);
            }
        }
        return roleFunctions;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public void reloadRoleResourceCache(Long roleId) {
        this.notifyCache(roleId);
    }

    @Override
    public void removeRoleFunctionByRoleId(Long roleId) {
        ((IRoleFunctionService)this.self()).removeByRoleId(roleId);
        this.removeCache(roleId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByRoleId(Long roleId) {
        this.rolefunctionMapper.deleteByRoleId(roleId);
    }

    private void removeCache(Long roleId) {
        this.roleFunctionCache.remove(roleId.toString());
        this.notifyCache(roleId);
    }

    private void notifyCache(Long roleId) {
        this.messagePublisher.publish("cache.role.resource", roleId);
    }
}

