/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.function.dto.ResourceItemElement;
import com.hand.hap.function.service.IResourceItemElementService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/resourceItemElement", "/api/sys/resourceItemElement"})
public class ResourceItemElementController
extends BaseController {
    @Autowired
    private IResourceItemElementService elementService;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData query(HttpServletRequest request, ResourceItemElement element) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.elementService.selectByResourceItemId(requestContext, element));
    }

    @PostMapping(value={"/submit"})
    public ResponseData submit(HttpServletRequest request, @RequestBody List<ResourceItemElement> elements, BindingResult result) {
        this.getValidator().validate(elements, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.elementService.batchUpdate(requestCtx, elements));
    }

    @PostMapping(value={"/remove"})
    public ResponseData remove(HttpServletRequest request, @RequestBody List<ResourceItemElement> elements) {
        IRequest requestContext = this.createRequestContext(request);
        this.elementService.batchDelete(requestContext, elements);
        return new ResponseData();
    }
}

