/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.dto.ResourceItem;
import com.hand.hap.function.service.IResourceItemService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/resourceItem", "/api/sys/resourceItem"})
public class ResourceItemController
extends BaseController {
    @Autowired
    private IResourceItemService resourceItemService;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData queryResourceItems(HttpServletRequest request, Resource resource) {
        return new ResponseData(this.resourceItemService.selectResourceItems(this.createRequestContext(request), resource));
    }

    @PostMapping(value={"/submit"})
    public ResponseData submitResourceItems(HttpServletRequest request, @RequestBody List<ResourceItem> resourceItems, BindingResult result) throws BaseException {
        this.getValidator().validate(resourceItems, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        return new ResponseData(this.resourceItemService.batchUpdate(this.createRequestContext(request), resourceItems));
    }

    @PostMapping(value={"/remove"})
    public ResponseData removeResourceItems(HttpServletRequest request, @RequestBody List<ResourceItem> resourceItems) throws BaseException {
        IRequest requestContext = this.createRequestContext(request);
        this.resourceItemService.batchDelete(requestContext, resourceItems);
        return new ResponseData();
    }
}

