/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.excel.service.impl;

import com.hand.hap.excel.ExcelException;
import com.hand.hap.excel.service.IHapExcelImportService;
import com.hand.hap.excel.service.impl.HapExcelExportImpl;
import com.hand.hap.excel.service.impl.HapExcelImportImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSession;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class HapExcelImportService
implements IHapExcelImportService {
    @Autowired
    @Qualifier(value="dataSource")
    DataSource dataSource;
    @Autowired
    SqlSession sqlSession;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void loadExcel(InputStream inputStream, String tableName) throws ExcelException {
        HapExcelImportImpl excelUtil = new HapExcelImportImpl(tableName, this.sqlSession);
        excelUtil.process(inputStream);
    }

    @Override
    public void exportExcelTemplate(String tableName, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) throws IOException, SQLException, ExcelException {
        SXSSFWorkbook wb = new SXSSFWorkbook();
        HapExcelExportImpl defaultHapExcelExport = new HapExcelExportImpl(wb, this.dataSource, null);
        HapExcelExportImpl.setExcelHeader(httpServletResponse, httpServletRequest, tableName);
        defaultHapExcelExport.createExcelTemplate(tableName, false);
        try {
            defaultHapExcelExport.write((OutputStream)httpServletResponse.getOutputStream());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExcelException("\u6a21\u677f\u751f\u6210\u5931\u8d25");
        }
        finally {
            defaultHapExcelExport.close();
        }
    }
}

