/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.excel.service.impl;

import com.hand.hap.excel.ExcelException;
import com.hand.hap.excel.annotation.ExcelJoinColumn;
import com.hand.hap.excel.service.impl.ExcelSheetStrategy;
import com.hand.hap.excel.service.impl.ExportStrategy;
import com.hand.hap.excel.util.TableUtils;
import com.hand.hap.mybatis.entity.EntityTable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HapExcelExportImpl {
    private CellStyle dateCellStyle;
    private CellStyle titleCellStyle;
    private CellStyle columnNameCellStyle;
    private SXSSFWorkbook wb;
    Connection connection;
    private List<String> containColumns;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, List<String>> columnMapping = new HashMap<String, List<String>>();
    SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.UK);

    public HapExcelExportImpl(SXSSFWorkbook workbook, DataSource dataSource, List<String> columns) throws SQLException {
        CellStyle dateFormat = workbook.createCellStyle();
        dateFormat.setDataFormat(workbook.createDataFormat().getFormat("yyyy-MM-dd HH:mm:ss"));
        this.dateCellStyle = dateFormat;
        this.titleCellStyle = workbook.createCellStyle();
        this.columnNameCellStyle = workbook.createCellStyle();
        short GREY_40_PERCENT = 23;
        this.titleCellStyle.setFillForegroundColor(GREY_40_PERCENT);
        this.titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font font = workbook.createFont();
        font.setColor(font.getIndex());
        this.titleCellStyle.setFont(font);
        this.columnNameCellStyle.setFillForegroundColor(GREY_40_PERCENT);
        this.columnNameCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.columnNameCellStyle.setFont(font);
        this.wb = workbook;
        this.containColumns = columns;
        this.connection = dataSource.getConnection();
    }

    public void fillSheet(List<Object> lists, Class dto) throws ClassNotFoundException, ExcelException {
        if (lists.size() == 0) {
            return;
        }
        String tableName = TableUtils.getTable(dto).getName();
        SXSSFSheet sheet = this.wb.getSheet(tableName);
        ExportStrategy exportStrategy = new ExportStrategy(this.connection, tableName);
        sheet.setColumnWidth(0, 1792);
        List columns = Optional.ofNullable(this.columnMapping.get(tableName)).orElseGet(() -> {
            ArrayList<String> column = new ArrayList<String>();
            SXSSFRow columnName = sheet.getRow(1);
            for (int i = 0; i < columnName.getLastCellNum(); ++i) {
                column.add(columnName.getCell(i).getStringCellValue());
                String type = exportStrategy.getCellType(columnName.getCell(i).getStringCellValue());
                this.setCellWidth(sheet, type, i);
            }
            this.columnMapping.put(tableName, column);
            return column;
        });
        int rowNum = sheet.getLastRowNum();
        for (int i = 0; i < lists.size(); ++i) {
            SXSSFRow row = sheet.createRow(rowNum + i + 1);
            this.createRow(row, lists.get(i), columns, exportStrategy);
        }
    }

    public void createRow(SXSSFRow row, Object object, List<String> columns, ExportStrategy exportStrategy) throws ExcelException {
        this.createCell(row.createCell(0), "*", "String");
        for (int i = 1; i < columns.size(); ++i) {
            String column = columns.get(i);
            String cell = null;
            try {
                cell = BeanUtils.getProperty((Object)object, (String)column);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String cellValue = null;
            try {
                Object v = exportStrategy.translateCellValue(column, cell, ExcelSheetStrategy.TranslateType.joinColumnToAlterCloumn, object);
                if (null != v) {
                    cellValue = v.toString();
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new ExcelException("cell\u5185\u5bb9\u66ff\u6362\u5931\u8d25");
            }
            this.createCell(row.createCell(i), cellValue, exportStrategy.getCellType(column));
        }
        this.getChildrenData(object);
    }

    public void getChildrenData(Object object) throws ExcelException {
        try {
            Class<?> parentClass = object.getClass();
            List<Class> childClasses = TableUtils.getChildren(parentClass);
            for (Class childClass : childClasses) {
                Object child = childClass.newInstance();
                List<Field> fields = TableUtils.getExcelJoinColumn(childClass);
                for (Field field : fields) {
                    ExcelJoinColumn ann = ((ExcelJoinColumn[])field.getAnnotationsByType(ExcelJoinColumn.class))[0];
                    if (ann.JoinTable() != parentClass) continue;
                    String value = BeanUtils.getProperty((Object)object, (String)ann.JoinColumn());
                    BeanUtils.setProperty(child, (String)field.getName(), (Object)value);
                }
                List<Object> responseData = TableUtils.getBaseMapperByType(childClass, ExcelSheetStrategy.MapperType.Select).select(child);
                this.fillSheet(responseData, childClass);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExcelException("\u83b7\u53d6\u5b50\u8868\u6570\u636e\u5931\u8d25");
        }
    }

    private void createSheetTemplate(Class dto, boolean containStdWho) throws IOException {
        EntityTable tableEntity = TableUtils.getTable(dto);
        SXSSFSheet sheet = this.createSheet(tableEntity.getName());
        sheet.setDefaultColumnWidth(20);
        List<String> column = TableUtils.getColumn(tableEntity, this.containColumns, containStdWho);
        List<String> title = TableUtils.getTitle(column, dto);
        SXSSFRow titleRow = sheet.createRow(0);
        SXSSFRow columnRow = sheet.createRow(1);
        this.createTemplateRow(title, titleRow);
        this.createTemplateRow(column, columnRow);
        for (int i = 0; i < titleRow.getLastCellNum(); ++i) {
            SXSSFCell cell = titleRow.getCell(i);
            SXSSFCell columnCell = columnRow.getCell(i);
            columnCell.setCellStyle(this.columnNameCellStyle);
            cell.setCellStyle(this.titleCellStyle);
        }
    }

    public void createExcelTemplate(String tableName, boolean containStdWho) throws IOException {
        ArrayList<Class> allTables = new ArrayList<Class>();
        TableUtils.getAllChildrenTable(TableUtils.getTableClass(tableName), allTables);
        for (Class tableDto : allTables) {
            this.createSheetTemplate(tableDto, containStdWho);
        }
    }

    public void createExcelTemplate(String tableName) throws IOException {
        this.createExcelTemplate(tableName, true);
    }

    public static void setExcelHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, String fileName) throws UnsupportedEncodingException {
        String name = fileName + ".xlsx";
        String userAgent = httpServletRequest.getHeader("User-Agent");
        name = userAgent.contains("Firefox") ? new String(name.getBytes("UTF-8"), "ISO8859-1") : URLEncoder.encode(name, "UTF-8");
        httpServletResponse.addHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
        httpServletResponse.setContentType("application/vnd.ms-excel;charset=UTF-8");
        httpServletResponse.setHeader("Accept-Ranges", "bytes");
    }

    public void createCell(SXSSFCell cell, String fieldObject, String type) {
        if (null == type) {
            type = fieldObject.getClass().getSimpleName();
        }
        if (null == fieldObject) {
            cell.setCellType(CellType.STRING);
            cell.setCellValue((String)null);
        } else {
            switch (type.toUpperCase()) {
                case "NUMBER": 
                case "FLOAT": {
                    cell.setCellType(CellType.NUMERIC);
                    cell.setCellValue((double)Float.valueOf(fieldObject).floatValue());
                    break;
                }
                case "DOUBLE": {
                    cell.setCellType(CellType.NUMERIC);
                    cell.setCellValue(Double.valueOf(fieldObject).doubleValue());
                    break;
                }
                case "INT": 
                case "INTEGER": 
                case "LONG": {
                    cell.setCellType(CellType.NUMERIC);
                    cell.setCellValue((double)Long.valueOf(fieldObject).longValue());
                    break;
                }
                case "DATE": {
                    Date date;
                    try {
                        date = this.sdf.parse(fieldObject);
                    }
                    catch (ParseException e) {
                        this.logger.error("can not parse date value,skip...");
                        break;
                    }
                    cell.setCellStyle(this.dateCellStyle);
                    cell.setCellValue(date);
                    break;
                }
                case "BOOLEAN": {
                    cell.setCellType(CellType.BOOLEAN);
                    cell.setCellValue(Boolean.valueOf(fieldObject).booleanValue());
                    break;
                }
                default: {
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue(fieldObject);
                }
            }
        }
    }

    public void setCellWidth(SXSSFSheet sheet, String type, int columnIndex) {
        if (null == type) {
            return;
        }
        switch (type.toUpperCase()) {
            case "STRING": {
                sheet.setColumnWidth(columnIndex, 5632);
                break;
            }
            case "NUMBER": 
            case "FLOAT": 
            case "DOUBLE": 
            case "INT": 
            case "INTEGER": 
            case "LONG": 
            case "BOOLEAN": {
                sheet.setColumnWidth(columnIndex, 3840);
                break;
            }
            case "DATE": {
                sheet.setColumnWidth(columnIndex, 6400);
                break;
            }
            default: {
                sheet.setColumnWidth(columnIndex, 5632);
            }
        }
    }

    public void createTemplateRow(List<String> title, SXSSFRow titleRow) {
        this.createCell(titleRow.createCell(0), "*", "String");
        for (int i = 0; i < title.size(); ++i) {
            this.createCell(titleRow.createCell(i + 1), title.get(i), "String");
        }
    }

    public SXSSFSheet createSheet(String sheetName) {
        return this.wb.createSheet(sheetName);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.wb.write(outputStream);
    }

    public void close() throws IOException {
        this.wb.close();
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw new RuntimeException("\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
        }
    }
}

