/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.ui;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.hand.hap.core.web.view.ReferenceType;
import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.ui.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Model {
    private static final String PROPERTITY_ID = "id";
    private static final String PROPERTITY_FIELDS = "fields";
    private static final String PROPERTITY_EDITABLE = "editable";
    private static final String PROPERTITY_NAME = "name";
    private static final String PROPERTITY_MODEL = "model";
    private String id;
    private Map<String, Field> fields;
    private ReferenceType editable;

    public static Model parseModel(XMap view) {
        Model m = null;
        if (view != null) {
            m = new Model();
            m.setId(view.getString(PROPERTITY_ID));
            m.addFields(Model.parseField(view.getChild(PROPERTITY_FIELDS)));
            if (view.getString(PROPERTITY_EDITABLE) != null) {
                m.setEditable(new ReferenceType(view.getString(PROPERTITY_EDITABLE)));
            }
            return m;
        }
        return m;
    }

    public static Map<String, Field> parseField(XMap fields) {
        if (fields != null) {
            List<XMap> list = fields.getChildren();
            HashMap<String, Field> map = new HashMap<String, Field>();
            if (list != null) {
                for (XMap m : list) {
                    if (m.getString(PROPERTITY_NAME) == null) continue;
                    map.put(m.getString(PROPERTITY_NAME), Field.parseField(m));
                }
            }
            return map;
        }
        return null;
    }

    public XMap toXMap() {
        XMap map = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_MODEL);
        map.put(PROPERTITY_ID, this.getId());
        map.put(PROPERTITY_EDITABLE, this.getEditable());
        XMap fields = map.getChild(PROPERTITY_FIELDS);
        if (fields == null) {
            fields = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_FIELDS);
        }
        if (this.getFields() != null) {
            for (Map.Entry<String, Field> entry : this.getFields().entrySet()) {
                XMap m = entry.getValue().toXMap();
                m.put(PROPERTITY_NAME, entry.getKey());
                fields.addChild(m);
            }
        }
        map.addChild(fields);
        return map;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ReferenceType getEditable() {
        return this.editable;
    }

    public void setEditable(ReferenceType editable) {
        this.editable = editable;
    }

    public void addFields(Map<String, Field> fields) {
        this.fields = fields;
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }
}

