/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ReferenceType;
import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.ui.InputField;
import java.util.HashMap;
import java.util.Map;

@UITag
public class MaskedTextBox
extends InputField {
    public static final String PROPERTITY_CLEAR_PROMPT_CHAR = "clearPromptChar";
    public static final String PROPERTITY_MASK = "mask";
    public static final String PROPERTITY_PROMPT_CHAR = "promptChar";
    public static final String PROPERTITY_RULES = "rules";
    public static final String PROPERTITY_UNMASK_ON_POST = "unmaskOnPost";
    public static final String PROPERTITY_CASE_LETTER = "caseLetter";

    public static MaskedTextBox createInstance() {
        XMap view = new XMap("h", "http://www.hand-china.com/hap", "maskedTextBox");
        MaskedTextBox instance = new MaskedTextBox();
        instance.initPrototype(view);
        return instance;
    }

    public Boolean getClearPromptChar() {
        return this.getPrototype().getBoolean(PROPERTITY_CLEAR_PROMPT_CHAR);
    }

    public void setClearPromptChar(Boolean clearPromptChar) {
        this.setPropertity(PROPERTITY_CLEAR_PROMPT_CHAR, clearPromptChar);
    }

    public String getMask() {
        return this.getPrototype().getString(PROPERTITY_MASK);
    }

    public void setMask(String mask) {
        this.setPropertity(PROPERTITY_MASK, mask);
    }

    public String getPromptChar() {
        return this.getPrototype().getString(PROPERTITY_PROMPT_CHAR);
    }

    public void setPromptChar(String promptChar) {
        this.setPropertity(PROPERTITY_PROMPT_CHAR, promptChar);
    }

    public Map<String, ReferenceType> getRules() {
        HashMap<String, ReferenceType> rules = new HashMap<String, ReferenceType>();
        XMap children = this.getPrototype().getChild(PROPERTITY_RULES);
        if (children != null) {
            children.getChildren(true).forEach(item -> rules.put(item.getString("name"), new ReferenceType(item.getString("value"))));
        }
        return rules;
    }

    public void addRule(String name, String rule) {
        XMap children = this.getPrototype().getChild(PROPERTITY_RULES);
        if (children != null) {
            children = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_RULES);
            this.getPrototype().addChild(children);
        }
        XMap child = new XMap("h", "http://www.hand-china.com/hap", "rule");
        child.put(name, rule);
        children.addChild(child);
    }

    public Boolean getUnmaskOnPost() {
        return this.getPrototype().getBoolean(PROPERTITY_UNMASK_ON_POST);
    }

    public void setUnmaskOnPost(Boolean unmaskOnPost) {
        this.setPropertity(PROPERTITY_UNMASK_ON_POST, unmaskOnPost);
    }

    public String getCaseLetter() {
        return this.getPrototype().getString(PROPERTITY_CASE_LETTER);
    }

    public void setCaseLetter(String caseLetter) {
        this.setPropertity(PROPERTITY_CASE_LETTER, caseLetter);
    }

    @Override
    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.addJsonConfig(PROPERTITY_CLEAR_PROMPT_CHAR, this.getClearPromptChar());
        context.addJsonConfig(PROPERTITY_MASK, this.getMask());
        context.addJsonConfig(PROPERTITY_PROMPT_CHAR, this.getPromptChar());
        context.addJsonConfig(PROPERTITY_RULES, this.getRules());
        context.addJsonConfig(PROPERTITY_UNMASK_ON_POST, this.getUnmaskOnPost());
        context.addJsonConfig(PROPERTITY_CASE_LETTER, this.getCaseLetter());
    }
}

