/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view;

import com.hand.hap.core.web.view.IterationHandle;
import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.xpath.XPathRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class XMapUtil {
    public static final String ANY_VALUE = "*";
    public static final String NULL_VALUE = "null";
    public static final String MERGE_ACTION = "action";
    public static final String MERGE_ACTION_AFTER = "after";
    public static final String MERGE_ACTION_BEFORE = "before";
    public static final String MERGE_ACTION_REPLACE = "replace";
    public static final String MERGE_ACTION_REMOVE = "remove";
    public static final String MERGE_ACTION_ATTRIBUTE = "attribute";

    public static List<XMap> findByName(XMap root, String nodeName) {
        if (root == null) {
            return null;
        }
        NameFinder cf = new NameFinder(nodeName);
        return cf.find(root);
    }

    public static void merge(XMap source, XMap dest) {
        List<XMap> list = XMapUtil.findByName(dest, "xpath");
        for (XMap xpath : list) {
            String action = xpath.getString(MERGE_ACTION);
            String express = xpath.getString("expr");
            XPathRequest request = new XPathRequest(express, xpath.getNamespaceMapping());
            XPathFinder cf = new XPathFinder(request);
            XMap result = cf.find(source);
            if (result == null) continue;
            AtomicInteger index = new AtomicInteger(result.getParent().getChildren().indexOf(result));
            if (MERGE_ACTION_REMOVE.equalsIgnoreCase(action)) {
                result.getParent().removeChild(result);
                continue;
            }
            if (MERGE_ACTION_ATTRIBUTE.equalsIgnoreCase(action)) {
                xpath.getChildren().forEach(child -> result.put(child.getString("name"), child.getString("value")));
                continue;
            }
            if (MERGE_ACTION_REPLACE.equalsIgnoreCase(action)) {
                result.getParent().remove(result);
                xpath.getChildren().forEach(child -> result.getParent().addChild(index.incrementAndGet(), (XMap)child));
                continue;
            }
            xpath.getChildren().forEach(child -> {
                if (MERGE_ACTION_AFTER.equalsIgnoreCase(action)) {
                    result.getParent().addChild(index.incrementAndGet(), (XMap)child);
                } else if (MERGE_ACTION_BEFORE.equalsIgnoreCase(action)) {
                    int i = index.get();
                    result.getParent().addChild(i >= 0 ? i : 0, (XMap)child);
                }
            });
        }
    }

    public static boolean compare(Object field, String value) {
        if (field == null) {
            if (value == null) {
                return true;
            }
            return NULL_VALUE.equals(value);
        }
        if (ANY_VALUE.equals(value)) {
            return true;
        }
        return field.toString().equals(value);
    }

    public static XMap findParentWithName(XMap map, String element_name) {
        for (XMap parent = map.getParent(); parent != null; parent = parent.getParent()) {
            if (element_name == null || !element_name.equals(parent.getName())) continue;
            return parent;
        }
        return null;
    }

    private static String getKey(XMap map, Object[] keys) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            buf.append(map.get(keys[i]));
        }
        return buf.toString();
    }

    public static void join(Collection list1, Collection list2, Object[] key_fields) {
        String key;
        HashMap<String, XMap> join_index = new HashMap<String, XMap>();
        for (XMap item : list1) {
            key = XMapUtil.getKey(item, key_fields);
            join_index.put(key, item);
        }
        for (XMap source : list2) {
            key = XMapUtil.getKey(source, key_fields);
            XMap target = (XMap)join_index.get(key);
            if (target == null) continue;
            target.putAll(source);
        }
        join_index.clear();
    }

    public static XMap collapse(XMap root) {
        List<XMap> childs = root.getChildren();
        if (childs == null) {
            return root;
        }
        ListIterator<XMap> it = childs.listIterator();
        while (it.hasNext()) {
            XMap child = it.next();
            String text = child.getText();
            if (child.size() == 0 && text != null && !"".equals(text.trim())) {
                root.put(child.getName(), text);
                it.remove();
                continue;
            }
            XMapUtil.collapse(child);
        }
        return root;
    }

    public static XMap expand(XMap root) {
        List<XMap> childs = root.getChildren();
        if (childs != null) {
            ListIterator<XMap> it = childs.listIterator();
            while (it.hasNext()) {
                XMap child = it.next();
                XMapUtil.expand(child);
            }
        }
        Set keyset = root.keySet();
        Iterator it = keyset.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            XMap keychild = new XMap(key);
            keychild.setText(root.getString(key));
            root.addChild(keychild);
        }
        HashSet hs = new HashSet();
        hs.addAll(keyset);
        for (Object key : hs) {
            root.remove(key);
        }
        return root;
    }

    public static void fillMap(Map target, XMap data, Object key_field) {
        Iterator<XMap> it = data.getChildIterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            XMap item = it.next();
            Object key = item.get(key_field);
            target.put(key, item);
        }
    }

    public static void fillMap(Map target, XMap data, Object key_field, Object value_field) {
        Iterator<XMap> it = data.getChildIterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            XMap item = it.next();
            Object key = item.get(key_field);
            Object value = item.get(value_field);
            target.put(key, value);
        }
    }

    public static String connectAttribute(XMap root, String attrib_name, String separator) {
        if (root == null) {
            return null;
        }
        Iterator<XMap> it = root.getChildIterator();
        if (it == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int id = 0;
        while (it.hasNext()) {
            XMap child = it.next();
            Object value = child.get(attrib_name);
            if (id > 0) {
                result.append(separator);
            }
            result.append(value);
            ++id;
        }
        return result.toString();
    }

    public static String connectAttribute(XMap root, String attrib_name) {
        return XMapUtil.connectAttribute(root, attrib_name, ",");
    }

    public static void copyAttributes(Map source, Map dest) {
        for (Map.Entry entry : source.entrySet()) {
            if (dest.containsKey(entry.getKey())) continue;
            dest.put(entry.getKey(), entry.getValue());
        }
    }

    public static void mergeChildsByOverride(XMap source, XMap dest, Object key) {
        Iterator<XMap> it = source.getChildIterator();
        if (it == null) {
            return;
        }
        HashMap dest_cache = new HashMap();
        XMapUtil.fillMap(dest_cache, dest, key);
        while (it.hasNext()) {
            XMap source_item = it.next();
            Object value = source_item.get(key);
            XMap dest_item = (XMap)dest_cache.get(value);
            if (dest_item != null) {
                XMapUtil.copyAttributes(source_item, dest_item);
                continue;
            }
            dest.addChild((XMap)source_item.clone());
        }
        dest_cache.clear();
    }

    public static void mergeChildsByReference(XMap source, XMap dest, Object key) {
        Iterator<XMap> it = dest.getChildIterator();
        if (it == null) {
            return;
        }
        HashMap source_cache = new HashMap();
        XMapUtil.fillMap(source_cache, source, key);
        while (it.hasNext()) {
            XMap dest_item = it.next();
            Object value = dest_item.get(key);
            XMap source_item = (XMap)source_cache.get(value);
            if (source_item == null) continue;
            XMapUtil.copyAttributes(source_item, dest_item);
        }
        source_cache.clear();
    }

    public static void getLevelChilds(XMap source, int level, List result) {
        if (source == null) {
            return;
        }
        if (level == 0) {
            result.add(source);
        }
        if (source.getChildren() == null) {
            return;
        }
        if (level == 1) {
            result.addAll(source.getChildren());
        } else if (level > 1) {
            Iterator<XMap> it = source.getChildIterator();
            while (it.hasNext()) {
                XMapUtil.getLevelChilds(it.next(), level - 1, result);
            }
        }
    }

    public static class NameFinder
    implements IterationHandle<List<XMap>> {
        private String nodeName;
        private List<XMap> result = new ArrayList<XMap>();

        @Override
        public List<XMap> find(XMap node) {
            if (node != null) {
                node.getRoot().iterate(this, true);
            }
            return this.getResult();
        }

        private List<XMap> getResult() {
            return this.result;
        }

        @Override
        public int process(XMap map) {
            if (StringUtils.equals((CharSequence)this.nodeName, (CharSequence)map.getName())) {
                this.result.add(map);
            }
            return 0;
        }

        public NameFinder(String nodeName) {
            this.nodeName = nodeName;
        }
    }

    public static class XPathFinder
    implements IterationHandle<XMap> {
        private XPathRequest request;
        private XMap result;

        public XPathFinder(XPathRequest request) {
            this.request = request;
        }

        @Override
        public int process(XMap node) {
            if (this.request.validate(node)) {
                this.result = node;
                return 2;
            }
            return 0;
        }

        private XMap getResult() {
            return this.result;
        }

        @Override
        public XMap find(XMap node) {
            if (node != null) {
                node.getRoot().iterate(this, true);
            }
            return this.getResult();
        }
    }
}

