/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class HapEnhanceFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HapServletRequestWrapper wrapper = new HapServletRequestWrapper((HttpServletRequest)request);
        chain.doFilter((ServletRequest)wrapper, response);
    }

    public void destroy() {
    }

    class HapServletRequestWrapper
    extends HttpServletRequestWrapper {
        private Map<String, String[]> extendMap;

        public HapServletRequestWrapper(HttpServletRequest request) {
            super(request);
            this.extendMap = null;
            this.initExtendMap((ServletRequest)request);
        }

        private void initExtendMap(ServletRequest request) {
            if (this.extendMap == null) {
                this.extendMap = new HashMap<String, String[]>(request.getParameterMap());
                String[] pageSize = this.extendMap.get("pageSize");
                String[] pagesize = this.extendMap.get("pagesize");
                if (pagesize != null) {
                    this.extendMap.put("pageSize", pagesize);
                }
                if (pageSize != null) {
                    this.extendMap.put("pagesize", pageSize);
                }
                this.extendMap = Collections.unmodifiableMap(this.extendMap);
            }
        }

        public String getParameter(String name) {
            String[] string = this.extendMap.get(name);
            if (string != null) {
                return string[0];
            }
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return this.extendMap;
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.extendMap.keySet());
        }

        public String[] getParameterValues(String name) {
            return this.extendMap.get(name);
        }
    }
}

