/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.i18n;

import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.TopicMonitor;
import com.hand.hap.system.dto.Prompt;
import com.hand.hap.system.service.IPromptService;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@TopicMonitor(channel={"cache.prompt.all"})
public class CacheMessageSource
extends AbstractMessageSource
implements IMessageConsumer<Prompt> {
    private static final String SINGLE_QUOTES_REPLACEMENT = "&#39;";
    private static final String DOUBLE_QUOTES_REPLACEMENT = "&#34;";
    public static final String CACHE_PROMPT_ALL = "cache.prompt.all";
    private Map<String, Map<String, String>> promptsMap = new ConcurrentHashMap<String, Map<String, String>>();
    @Autowired
    private IPromptService promptService;

    public CacheMessageSource() {
        this.reload();
    }

    public void reload() {
    }

    @Override
    public void onMessage(Prompt message, String pattern) {
        Map<String, String> prompts = this.promptsMap.get(message.getLang());
        if (!CollectionUtils.isEmpty(prompts)) {
            prompts.remove(message.getPromptCode());
            String description = this.promptService.getPromptDescription(message.getLang(), message.getPromptCode());
            if (StringUtils.isNotEmpty((String)description)) {
                prompts.put(message.getPromptCode(), description);
            }
        }
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        return this.createMessageFormat(this.resolveCodeWithoutArguments(code, locale), locale);
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        String code2 = StringUtils.lowerCase((String)code);
        String description = this.resolveCodeFromMap(code2, locale.toString());
        if (description == null) {
            return code;
        }
        return this.replaceQuote(description);
    }

    private String resolveCodeFromMap(String code, String locale) {
        String description;
        Map<String, String> prompts = this.promptsMap.get(locale);
        if (CollectionUtils.isEmpty(prompts)) {
            prompts = new ConcurrentHashMap<String, String>(5000);
        }
        if ((description = prompts.get(code)) == null && (description = this.promptService.getPromptDescription(locale, code)) != null) {
            prompts.put(code, description);
            this.promptsMap.put(locale, prompts);
        }
        return description;
    }

    private String replaceQuote(String str) {
        int idx = -1;
        char c = '\u0000';
        for (int i = 0; i < str.length(); ++i) {
            c = str.charAt(i);
            if (c != '\'' && c != '\"') continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return str;
        }
        StrBuilder sb = new StrBuilder(str.length() + 32);
        sb.append(str.substring(0, idx));
        if (c == '\"') {
            sb.append(DOUBLE_QUOTES_REPLACEMENT);
        } else {
            sb.append(SINGLE_QUOTES_REPLACEMENT);
        }
        for (int i = idx + 1; i < str.length(); ++i) {
            c = str.charAt(i);
            if (c == '\"') {
                sb.append(DOUBLE_QUOTES_REPLACEMENT);
                continue;
            }
            if (c == '\'') {
                sb.append(SINGLE_QUOTES_REPLACEMENT);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

