/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.function.mapper.RoleFunctionMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleResourceCache
extends HashStringRedisCache<Long[]> {
    private String roleResourceQuerySqlId = RoleFunctionMapper.class.getName() + ".selectAllRoleResources";
    private String roleResourcesSqlId = RoleFunctionMapper.class.getName() + ".selectRoleResources";
    private final Logger logger = LoggerFactory.getLogger(RoleResourceCache.class);

    public RoleResourceCache() {
        this.setLoadOnStartUp(true);
        this.setType(Long[].class);
    }

    @Override
    public Long[] getValue(String key) {
        return (Long[])super.getValue(key);
    }

    @Override
    public void setValue(String key, Long[] values) {
        super.setValue(key, values);
    }

    @Override
    protected void initLoad() {
        block14: {
            HashMap<String, Set> roleResources = new HashMap<String, Set>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.roleResourceQuerySqlId, resultContext -> {
                    Map value = (Map)resultContext.getResultObject();
                    String roleId = "" + value.get("ROLE_ID");
                    HashSet<Long> sets = (HashSet<Long>)roleResources.get(roleId);
                    if (sets == null) {
                        sets = new HashSet<Long>();
                        roleResources.put(roleId, sets);
                    }
                    Long resourceId = ((Number)value.get("RESOURCE_ID")).longValue();
                    sets.add(resourceId);
                });
                roleResources.forEach((k, v) -> this.setValue((String)k, v.toArray(new Long[v.size()])));
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("init role resource cache exception: ", (Throwable)e);
            }
        }
    }

    public void loadRoleResource(Long roleId) {
        block14: {
            HashMap<Long, Set> roleResources = new HashMap<Long, Set>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.roleResourcesSqlId, (Object)roleId, resultContext -> {
                    Map value = (Map)resultContext.getResultObject();
                    HashSet<Long> sets = (HashSet<Long>)roleResources.get(roleId);
                    if (sets == null) {
                        sets = new HashSet<Long>();
                        roleResources.put(roleId, sets);
                    }
                    Long resourceId = ((Number)value.get("RESOURCE_ID")).longValue();
                    sets.add(resourceId);
                });
                roleResources.forEach((k, v) -> this.setValue(k.toString(), v.toArray(new Long[v.size()])));
            }
            catch (RuntimeException e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("loadRoleResource exception: ", (Throwable)e);
            }
        }
    }
}

