/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.function.dto.ResourceItem;
import com.hand.hap.function.mapper.ResourceItemMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceItemCache
extends HashStringRedisCache<ResourceItem[]> {
    private String resourceItemQueryAllSqlId = ResourceItemMapper.class.getName() + ".selectForCache";
    private String resourceItemQuerySqlId = ResourceItemMapper.class.getName() + ".selectResourceItemsByResourceId";
    private final Logger logger = LoggerFactory.getLogger(ResourceItemCache.class);

    public ResourceItemCache() {
        this.setLoadOnStartUp(true);
        this.setType(ResourceItem[].class);
    }

    @Override
    public ResourceItem[] getValue(String key) {
        return (ResourceItem[])super.getValue(key);
    }

    @Override
    public void setValue(String key, ResourceItem[] values) {
        super.setValue(key, values);
    }

    @Override
    protected void initLoad() {
        block15: {
            HashMap<String, List> resourceResourceItems = new HashMap<String, List>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.resourceItemQueryAllSqlId, resultContext -> {
                    ResourceItem value = (ResourceItem)resultContext.getResultObject();
                    String ownerResourceId = value.getOwnerResourceId().toString();
                    ArrayList<ResourceItem> resourceItems = (ArrayList<ResourceItem>)resourceResourceItems.get(ownerResourceId);
                    if (resourceItems == null) {
                        resourceItems = new ArrayList<ResourceItem>();
                        resourceResourceItems.put(ownerResourceId, resourceItems);
                    }
                    resourceItems.add(value);
                });
                resourceResourceItems.forEach((k, v) -> this.setValue((String)k, v.toArray(new ResourceItem[v.size()])));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("successfully loaded all resource item cache");
                }
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block15;
                this.logger.error("init resource item cache exception: ", e);
            }
        }
    }

    public void load(String resourceId) {
        block14: {
            HashMap<String, List> resourceResourceItems = new HashMap<String, List>();
            super.remove(resourceId);
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.resourceItemQuerySqlId, (Object)Long.parseLong(resourceId), resultContext -> {
                    ResourceItem value = (ResourceItem)resultContext.getResultObject();
                    ArrayList<ResourceItem> sets = (ArrayList<ResourceItem>)resourceResourceItems.get(resourceId);
                    if (sets == null) {
                        sets = new ArrayList<ResourceItem>();
                        resourceResourceItems.put(resourceId, sets);
                    }
                    sets.add(value);
                });
                resourceResourceItems.forEach((k, v) -> this.setValue((String)k, v.toArray(new ResourceItem[v.size()])));
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("load resource item cache exception: ", e);
            }
        }
    }
}

