/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.function.dto.ResourceItemAssign;
import com.hand.hap.function.mapper.ResourceItemAssignMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceItemAssignCache
extends HashStringRedisCache<ResourceItemAssign[]> {
    private String queryAllSqlId = ResourceItemAssignMapper.class.getName() + ".selectAll";
    private String querySqlId = ResourceItemAssignMapper.class.getName() + ".selectByTypeId";
    private final Logger logger = LoggerFactory.getLogger(ResourceItemAssignCache.class);

    public ResourceItemAssignCache() {
        this.setLoadOnStartUp(true);
        this.setType(ResourceItemAssign[].class);
    }

    @Override
    public ResourceItemAssign[] getValue(String key) {
        return (ResourceItemAssign[])super.getValue(key);
    }

    @Override
    public void setValue(String key, ResourceItemAssign[] values) {
        super.setValue(key, values);
    }

    @Override
    protected void initLoad() {
        block15: {
            HashMap<String, List> assignResourceItems = new HashMap<String, List>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.queryAllSqlId, resultContext -> {
                    ResourceItemAssign value = (ResourceItemAssign)resultContext.getResultObject();
                    String key = value.getAssignType() + "_" + value.getTypeId().toString();
                    ArrayList<ResourceItemAssign> resourceItems = (ArrayList<ResourceItemAssign>)assignResourceItems.get(key);
                    if (resourceItems == null) {
                        resourceItems = new ArrayList<ResourceItemAssign>();
                        assignResourceItems.put(key, resourceItems);
                    }
                    resourceItems.add(value);
                });
                assignResourceItems.forEach((k, v) -> this.setValue((String)k, v.toArray(new ResourceItemAssign[v.size()])));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("successfully loaded all assign resource item cache");
                }
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block15;
                this.logger.error("init assign resource item cache exception: ", (Throwable)e);
            }
        }
    }

    public void load(String key) {
        block14: {
            HashMap<String, List> assignResourceItems = new HashMap<String, List>();
            super.remove(key);
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.querySqlId, (Object)this.setResourceItemAssign(key), resultContext -> {
                    ResourceItemAssign value = (ResourceItemAssign)resultContext.getResultObject();
                    ArrayList<ResourceItemAssign> sets = (ArrayList<ResourceItemAssign>)assignResourceItems.get(key);
                    if (sets == null) {
                        sets = new ArrayList<ResourceItemAssign>();
                        assignResourceItems.put(key, sets);
                    }
                    sets.add(value);
                });
                assignResourceItems.forEach((k, v) -> this.setValue((String)k, v.toArray(new ResourceItemAssign[v.size()])));
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("load assign resource item cache exception: ", (Throwable)e);
            }
        }
    }

    private ResourceItemAssign setResourceItemAssign(String key) {
        String[] assignArr = key.split("_");
        ResourceItemAssign assign = new ResourceItemAssign();
        assign.setAssignType(assignArr[0]);
        assign.setTypeId(Long.parseLong(assignArr[1]));
        return assign;
    }
}

