/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Throwables;
import com.hand.hap.activiti.components.ActivitiMultiLanguageManager;
import com.hand.hap.activiti.core.IActivitiConstants;
import com.hand.hap.activiti.custom.ForecastActivityCmd;
import com.hand.hap.activiti.custom.GetExpressionValueCmd;
import com.hand.hap.activiti.custom.ICustomTaskProcessor;
import com.hand.hap.activiti.custom.JumpActivityCmd;
import com.hand.hap.activiti.custom.process.CustomHistoricProcessInstanceQueryResource;
import com.hand.hap.activiti.custom.task.CustomTaskQueryResource;
import com.hand.hap.activiti.dto.ActivitiNode;
import com.hand.hap.activiti.dto.ApproveChainHeader;
import com.hand.hap.activiti.dto.HiIdentitylink;
import com.hand.hap.activiti.dto.HistoricProcessInstanceResponseExt;
import com.hand.hap.activiti.dto.HistoricTaskInstanceResponseExt;
import com.hand.hap.activiti.dto.ProcessInstanceForecast;
import com.hand.hap.activiti.dto.ProcessInstanceResponseExt;
import com.hand.hap.activiti.dto.TaskActionRequestExt;
import com.hand.hap.activiti.dto.TaskDelegate;
import com.hand.hap.activiti.dto.TaskInfo;
import com.hand.hap.activiti.dto.TaskResponseExt;
import com.hand.hap.activiti.event.TaskRecallEvent;
import com.hand.hap.activiti.event.dto.TaskRecallInfo;
import com.hand.hap.activiti.exception.TaskActionException;
import com.hand.hap.activiti.exception.WflSecurityException;
import com.hand.hap.activiti.exception.dto.ActiviException;
import com.hand.hap.activiti.exception.mapper.ActiviExceptionMapper;
import com.hand.hap.activiti.listeners.TaskCreateNotificationListener;
import com.hand.hap.activiti.mapper.HiIdentitylinkMapper;
import com.hand.hap.activiti.service.IActivitiEntityService;
import com.hand.hap.activiti.service.IActivitiService;
import com.hand.hap.activiti.service.IApproveChainHeaderService;
import com.hand.hap.activiti.util.ActivitiUtils;
import com.hand.hap.core.IRequest;
import com.hand.hap.hr.dto.Employee;
import com.hand.hap.hr.service.IEmployeeService;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.mybatis.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.form.FormData;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.CommentEntityImpl;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.activiti.engine.impl.persistence.entity.data.GroupDataManager;
import org.activiti.engine.impl.persistence.entity.data.UserDataManager;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.activiti.rest.common.api.DataResponse;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.api.engine.variable.RestVariable;
import org.activiti.rest.service.api.history.HistoricProcessInstanceCollectionResource;
import org.activiti.rest.service.api.history.HistoricProcessInstanceQueryRequest;
import org.activiti.rest.service.api.history.HistoricTaskInstanceQueryRequest;
import org.activiti.rest.service.api.history.HistoricTaskInstanceQueryResource;
import org.activiti.rest.service.api.history.HistoricTaskInstanceResponse;
import org.activiti.rest.service.api.management.DeadLetterJobCollectionResource;
import org.activiti.rest.service.api.runtime.process.ExecutionVariableCollectionResource;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceCollectionResource;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceCreateRequest;
import org.activiti.rest.service.api.runtime.process.ProcessInstanceResponse;
import org.activiti.rest.service.api.runtime.task.TaskActionRequest;
import org.activiti.rest.service.api.runtime.task.TaskQueryRequest;
import org.activiti.rest.service.api.runtime.task.TaskResource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.stereotype.Service;

@Service
public class ActivitiServiceImpl
implements IActivitiService,
IActivitiConstants,
InitializingBean {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private GroupDataManager groupDataManager;
    @Autowired
    private UserDataManager userDataManager;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private FormService formService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RestResponseFactory restResponseFactory;
    @Autowired
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    @Autowired
    private ActiviExceptionMapper exceptionMapper;
    @Autowired
    private IEmployeeService employeeService;
    @Autowired
    private IActivitiEntityService entityService;
    @Autowired
    private ForecastActivityCmd forecastActivityCmd;
    @Autowired
    private HiIdentitylinkMapper hiIdentitylinkMapper;
    @Autowired
    private TaskCreateNotificationListener taskCreateNotificationListener;
    @Autowired
    IApproveChainHeaderService approveChainHeaderService;
    @Autowired
    private IMessagePublisher messagePublisher;
    @Autowired
    private ApplicationEventPublisher publisher;
    private TaskResource taskResource = new TaskResource();
    private ExecutionVariableCollectionResource executionVariableCollectionResource = new ExecutionVariableCollectionResource();
    private CustomTaskQueryResource taskQueryResource = new CustomTaskQueryResource();
    private CustomHistoricProcessInstanceQueryResource historicProcessInstanceQueryResource = new CustomHistoricProcessInstanceQueryResource();
    private ProcessInstanceCollectionResource processInstanceCollectionResource = new ProcessInstanceCollectionResource();
    private HistoricTaskInstanceQueryResource historicTaskInstanceQueryResource = new HistoricTaskInstanceQueryResource();
    private HistoricProcessInstanceCollectionResource historicProcessInstanceCollectionResource = new HistoricProcessInstanceCollectionResource();
    private DeadLetterJobCollectionResource deadLetterJobCollectionResource = new DeadLetterJobCollectionResource();
    private HttpServletRequest fakeRequest = new MockHttpServletRequest();
    private HttpServletResponse fakeResponse = new MockHttpServletResponse();
    private List<ICustomTaskProcessor> taskProcessors;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessInstanceResponse startProcess(IRequest iRequest, ProcessInstanceCreateRequest createRequest) {
        try {
            String employeeCode = iRequest.getEmployeeCode();
            Authentication.setAuthenticatedUserId((String)employeeCode);
            ProcessInstanceResponse processInstanceResponse = this.processInstanceCollectionResource.createProcessInstance(createRequest, this.fakeRequest, this.fakeResponse);
            return processInstanceResponse;
        }
        finally {
            Authentication.setAuthenticatedUserId(null);
        }
    }

    public DataResponse getInvolvedProcess(IRequest request, Map<String, String> allParameters) {
        return this.processInstanceCollectionResource.getProcessInstances(allParameters, this.fakeRequest);
    }

    @Override
    public Model deployModel(String modelId) throws Exception {
        Model model = this.repositoryService.getModel(modelId);
        byte[] modelData = this.repositoryService.getModelEditorSource(modelId);
        JsonNode jsonNode = this.objectMapper.readTree(modelData);
        BpmnModel bpmnModel = new BpmnJsonConverter().convertToBpmnModel(jsonNode);
        Deployment deploy = this.repositoryService.createDeployment().category(model.getCategory()).name(model.getName()).key(model.getKey()).addBpmnModel(model.getKey() + ".bpmn20.xml", bpmnModel).deploy();
        model.setDeploymentId(deploy.getId());
        this.repositoryService.saveModel(model);
        return model;
    }

    @Override
    public void completeTask(IRequest request, Task taskEntity, TaskActionRequestExt actionRequest) throws TaskActionException {
        if (!"complete".equalsIgnoreCase(actionRequest.getAction())) {
            return;
        }
        Authentication.setAuthenticatedUserId((String)request.getEmployeeCode());
        String action = null;
        String taskId = taskEntity.getId();
        List vars = actionRequest.getVariables();
        if (vars != null) {
            for (RestVariable rv : vars) {
                if (!"approveResult".equalsIgnoreCase(rv.getName())) continue;
                action = String.valueOf(rv.getValue());
                break;
            }
        }
        actionRequest.setAssignee(request.getEmployeeCode());
        this.taskService.addComment(taskId, taskEntity.getProcessInstanceId(), "action", action);
        this.taskService.addComment(taskId, taskEntity.getProcessInstanceId(), "comment", actionRequest.getComment());
        this.taskResource.executeTaskAction(taskId, (TaskActionRequest)actionRequest);
        if (StringUtils.isNotEmpty((String)actionRequest.getAction())) {
            this.taskCreateNotificationListener.sendMessage(actionRequest.getAssignee());
        }
        this.taskCreateNotificationListener.sendMessage(taskEntity.getAssignee());
    }

    @Override
    public void delegateTask(IRequest request, Task taskEntity, TaskActionRequestExt actionRequest) throws TaskActionException {
        if (!"delegate".equalsIgnoreCase(actionRequest.getAction())) {
            return;
        }
        Authentication.setAuthenticatedUserId((String)request.getEmployeeCode());
        String assignee = actionRequest.getAssignee();
        if (StringUtils.isEmpty((String)assignee)) {
            throw new TaskActionException("wfl.error.delegate_without_assignee");
        }
        String taskId = taskEntity.getId();
        this.taskService.addComment(taskId, taskEntity.getProcessInstanceId(), "action", "DELEGATE");
        this.taskService.addComment(taskId, taskEntity.getProcessInstanceId(), "comment", request.getEmployeeCode() + "\u8f6c\u4ea4\u7ed9" + assignee + "  " + actionRequest.getComment());
        this.taskService.setAssignee(taskId, assignee);
        this.taskCreateNotificationListener.sendMessage(taskEntity.getAssignee());
        this.taskCreateNotificationListener.sendMessage(assignee);
    }

    @Override
    public void resolveTask(IRequest request, Task taskEntity, TaskActionRequestExt actionRequest) throws TaskActionException {
        if (!"resolve".equalsIgnoreCase(actionRequest.getAction())) {
            return;
        }
        Authentication.setAuthenticatedUserId((String)request.getEmployeeCode());
        String taskId = taskEntity.getId();
        String action = null;
        List vars = actionRequest.getVariables();
        if (vars != null) {
            for (RestVariable rv : vars) {
                if (!"approveResult".equalsIgnoreCase(rv.getName())) continue;
                action = String.valueOf(rv.getValue());
                break;
            }
        }
        this.taskService.addComment(taskId, taskEntity.getProcessInstanceId(), "action", action);
        this.taskService.addComment(taskId, taskEntity.getProcessInstanceId(), "comment", actionRequest.getComment());
        this.taskService.resolveTask(taskId);
        this.taskCreateNotificationListener.sendMessage(taskEntity.getOwner());
        this.taskCreateNotificationListener.sendMessage(taskEntity.getAssignee());
    }

    public void addSignTask(IRequest request, Task taskEntity, TaskActionRequestExt actionRequest) {
        if (!"addSign".equalsIgnoreCase(actionRequest.getAction())) {
            return;
        }
        Authentication.setAuthenticatedUserId((String)request.getEmployeeCode());
        String assignee = actionRequest.getAssignee();
        String taskId = taskEntity.getId();
        this.taskService.addComment(taskId, taskEntity.getProcessInstanceId(), "action", "ADD_SIGN");
        this.taskService.addComment(taskId, taskEntity.getProcessInstanceId(), "comment", actionRequest.getComment());
        this.taskService.delegateTask(taskId, assignee);
        this.taskCreateNotificationListener.sendMessage(assignee);
        this.taskCreateNotificationListener.sendMessage(taskEntity.getAssignee());
    }

    @Override
    public void carbonCopy(IRequest request, Task taskEntity, TaskActionRequestExt actionRequest) throws TaskActionException {
        Authentication.setAuthenticatedUserId((String)request.getEmployeeCode());
        String assignee = actionRequest.getCarbonCopyUsers();
        if (StringUtil.isNotEmpty(assignee)) {
            Set users = org.springframework.util.StringUtils.commaDelimitedListToSet((String)assignee);
            String processInstanceId = taskEntity.getProcessInstanceId();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("processInstanceId", processInstanceId);
            params.put("users", users);
            String comment = request.getEmployeeCode() + " \u6284\u9001\u7ed9 " + assignee;
            this.taskService.addComment(taskEntity.getId(), processInstanceId, "action", "CARBON_COPY");
            this.taskService.addComment(taskEntity.getId(), processInstanceId, "comment", comment);
            this.messagePublisher.message("wfl.carbon.copy", params);
        }
    }

    @Override
    public void processCarbonCopyRead(String processInstanceId, String employeeCode) {
        HiIdentitylink dto = new HiIdentitylink();
        dto.setProcInstId_(processInstanceId);
        dto.setReadFlag_("Y");
        dto.setUserId_(employeeCode);
        this.hiIdentitylinkMapper.updateReadFlag(dto);
        this.taskCreateNotificationListener.sendMessageForCC(employeeCode);
    }

    @Override
    public void jumpTo(IRequest request, Task taskEntity, TaskActionRequestExt actionRequest) {
        if (!"jump".equalsIgnoreCase(actionRequest.getAction())) {
            return;
        }
        Authentication.setAuthenticatedUserId((String)request.getEmployeeCode());
        String taskId = taskEntity.getId();
        this.taskService.addComment(taskId, taskEntity.getProcessInstanceId(), "action", "JUMP");
        this.taskService.addComment(taskId, taskEntity.getProcessInstanceId(), "comment", "\u4ece<" + taskEntity.getName() + ">\u8df3\u8f6c\u81f3<" + actionRequest.getJumpTargetName() + ">");
        JumpActivityCmd cmd = new JumpActivityCmd(taskId, actionRequest.getJumpTarget());
        this.processEngineConfiguration.getCommandExecutor().execute((Command)cmd);
        if (StringUtils.isNotEmpty((String)taskEntity.getAssignee())) {
            this.taskCreateNotificationListener.sendMessage(taskEntity.getAssignee());
        }
    }

    protected boolean hasRight(String a, String b, boolean isAdmin) {
        return isAdmin || this.eq(a, b);
    }

    protected boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    @Override
    public void executeTaskAction(IRequest request, String taskId, TaskActionRequestExt actionRequest, boolean isAdmin) throws TaskActionException {
        if (StringUtils.isEmpty((String)actionRequest.getAction())) {
            throw new IllegalArgumentException("Action is required.");
        }
        Task taskEntity = this.getTaskById(taskId);
        List idList = null;
        if (taskEntity.getAssignee() == null) {
            idList = this.taskService.getIdentityLinksForTask(taskId);
            if (isAdmin) {
                this.taskService.claim(taskId, request.getEmployeeCode());
            } else {
                HashSet nameList = new HashSet();
                List userGroup = null;
                boolean isCandi = false;
                block2: for (IdentityLink il : idList) {
                    if (il.getUserId() != null) {
                        if (!this.eq(request.getEmployeeCode(), il.getUserId())) continue;
                        isCandi = true;
                        break;
                    }
                    if (il.getGroupId() == null) continue;
                    userGroup = this.processEngineConfiguration.getUserDataManager().findGroupsByUser(request.getEmployeeCode());
                    for (Group g : userGroup) {
                        if (!this.eq(g.getId(), il.getGroupId())) continue;
                        isCandi = true;
                        continue block2;
                    }
                }
                if (!isCandi) {
                    throw new TaskActionException("wfl.security.error.need_assignee_or_admin");
                }
                this.taskService.claim(taskId, request.getEmployeeCode());
                taskEntity.setAssignee(request.getEmployeeCode());
            }
        }
        if (!this.hasRight(request.getEmployeeCode(), taskEntity.getAssignee(), isAdmin)) {
            throw new TaskActionException("wfl.error.complete_task_need_assignee_or_admin");
        }
        Authentication.setAuthenticatedUserId((String)request.getEmployeeCode());
        try {
            this.carbonCopy(request, taskEntity, actionRequest);
            if ("complete".equalsIgnoreCase(actionRequest.getAction())) {
                this.completeTask(request, taskEntity, actionRequest);
                return;
            }
            if ("delegate".equalsIgnoreCase(actionRequest.getAction())) {
                this.delegateTask(request, taskEntity, actionRequest);
                this.processCandidateMsg(idList);
                return;
            }
            if ("resolve".equalsIgnoreCase(actionRequest.getAction())) {
                this.resolveTask(request, taskEntity, actionRequest);
                return;
            }
            if ("jump".equalsIgnoreCase(actionRequest.getAction())) {
                this.jumpTo(request, taskEntity, actionRequest);
                return;
            }
            if ("addSign".equals(actionRequest.getAction())) {
                this.addSignTask(request, taskEntity, actionRequest);
                this.processCandidateMsg(idList);
                return;
            }
        }
        catch (ActivitiException e) {
            ((IActivitiService)this.self()).saveException(taskId, e);
            throw e;
        }
    }

    private void processCandidateMsg(List<IdentityLink> idList) {
        if (idList != null) {
            for (IdentityLink il : idList) {
                if (il.getUserId() != null) {
                    this.taskCreateNotificationListener.sendMessage(il.getUserId());
                    continue;
                }
                if (il.getGroupId() == null) continue;
                this.taskCreateNotificationListener.sendMessageByGroup(il.getGroupId());
            }
        }
    }

    @Override
    public void saveException(String taskId, ActivitiException e) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String mess = Throwables.getStackTraceAsString((Throwable)e);
        this.exceptionMapper.insertSelective(new ActiviException(task.getProcessInstanceId(), mess, new Date()));
    }

    @Override
    public void deleteDeployment(String deploymentId, Boolean cascade) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
        String processDefinitionId = processDefinition.getId();
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionId(processDefinitionId)).list();
        HashSet users = new HashSet();
        taskList.forEach(t -> {
            if (t.getAssignee() != null) {
                users.add(t.getAssignee());
            }
        });
        if (cascade.booleanValue()) {
            this.repositoryService.deleteDeployment(deploymentId, true);
        } else {
            this.repositoryService.deleteDeployment(deploymentId);
        }
        for (String user : users) {
            this.taskCreateNotificationListener.sendMessage(user);
            this.taskCreateNotificationListener.sendMessageForCC(user);
        }
    }

    @Override
    public void deleteProcessInstance(String processInstanceId) {
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        HashSet users = new HashSet();
        taskList.forEach(t -> {
            if (t.getAssignee() != null) {
                users.add(t.getAssignee());
            }
        });
        this.runtimeService.deleteProcessInstance(processInstanceId, "STOP");
        for (String user : users) {
            this.taskCreateNotificationListener.sendMessage(user);
        }
    }

    @Override
    public List<ActivitiNode> getProcessNodes(IRequest request, String processInstanceId) {
        List historicActivityInstanceList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityType("userTask").orderByHistoricActivityInstanceEndTime().asc()).list();
        String processDefinitionId = ((HistoricActivityInstance)historicActivityInstanceList.get(0)).getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        ArrayList<ActivitiNode> list = new ArrayList<ActivitiNode>();
        Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof UserTask)) continue;
            ActivitiNode node = new ActivitiNode();
            node.setName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode(flowElement.getName(), request));
            node.setNodeId(flowElement.getId());
            node.setType("UserTask");
            list.add(node);
        }
        return list;
    }

    @Override
    public List<ActivitiNode> getUserTaskFromModelSource(IRequest request, String modelId) {
        ArrayList<ActivitiNode> list = new ArrayList<ActivitiNode>();
        byte[] data = this.repositoryService.getModelEditorSource(modelId);
        JsonNode jsonNode = null;
        try {
            jsonNode = this.objectMapper.readTree(data);
            BpmnModel bpmnModel = new BpmnJsonConverter().convertToBpmnModel(jsonNode);
            Process process = bpmnModel.getMainProcess();
            Collection elements = process.getFlowElements();
            for (FlowElement flowElement : elements) {
                if (!(flowElement instanceof UserTask)) continue;
                ActivitiNode node = new ActivitiNode();
                node.setNodeId(flowElement.getId());
                node.setName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode(flowElement.getName(), request));
                node.setType("UserTask");
                list.add(node);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    @Override
    public String getEmployeeName(String userId) {
        UserEntity userEntity = (UserEntity)this.userDataManager.findById(userId);
        if (userEntity != null && StringUtils.isNotEmpty((String)userEntity.getFirstName())) {
            return userEntity.getFirstName();
        }
        return userId;
    }

    @Override
    public String getGroupName(String groupId) {
        Group group = (Group)this.groupDataManager.findById(groupId);
        if (group != null) {
            return group.getName();
        }
        return groupId;
    }

    @Override
    public HistoricProcessInstanceResponseExt getInstanceDetail(IRequest request, String processInstanceId) {
        HistoricProcessInstanceResponseExt historicProcessInstanceResponseExt = new HistoricProcessInstanceResponseExt();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).list().iterator().next();
        historicProcessInstanceResponseExt.setStartUserId(historicProcessInstance.getStartUserId());
        historicProcessInstanceResponseExt.setStartUserName(this.getEmployeeName(historicProcessInstance.getStartUserId()));
        historicProcessInstanceResponseExt.setProcessName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode(historicProcessInstance.getProcessDefinitionName(), request));
        historicProcessInstanceResponseExt.setStartTime(historicProcessInstance.getStartTime());
        List historicActivityInstanceList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        ArrayList<HistoricTaskInstanceResponseExt> list = new ArrayList<HistoricTaskInstanceResponseExt>();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstanceList) {
            this.setHistoricActivityInstanceResponseExt(historicActivityInstance, list, processInstanceId, request);
        }
        list.sort(Comparator.comparing(HistoricTaskInstanceResponse::getEndTime));
        historicProcessInstanceResponseExt.getHistoricTaskList().addAll(list);
        String key = this.formService.getStartFormKey(historicProcessInstance.getProcessDefinitionId());
        historicProcessInstanceResponseExt.setBusinessKey(historicProcessInstance.getBusinessKey());
        historicProcessInstanceResponseExt.setFormKey(key);
        List variables = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(historicProcessInstance.getId()).list();
        historicProcessInstanceResponseExt.setDescription(this.getProcessDescription(historicProcessInstance.getProcessDefinitionId(), variables.stream().collect(Collectors.toMap(vk -> vk.getVariableName(), value -> value.getValue() == null ? "" : value.getValue(), (existingValue, newValue) -> newValue))));
        return historicProcessInstanceResponseExt;
    }

    @Override
    public TaskResponseExt getTaskDetails(IRequest request, String taskId, boolean isAdmin) throws WflSecurityException {
        Task task = this.getTaskById(taskId);
        TaskResponseExt taskExt = new TaskResponseExt(task);
        List userGroup = null;
        if (StringUtils.isNotEmpty((String)taskExt.getAssignee())) {
            if (!this.hasRight(request.getEmployeeCode(), taskExt.getAssignee(), isAdmin)) {
                throw new WflSecurityException("wfl.security.error.need_assignee_or_admin");
            }
            taskExt.setAssigneeName(this.getEmployeeName(taskExt.getAssignee()));
        } else {
            List idList = this.taskService.getIdentityLinksForTask(task.getId());
            ArrayList<String> nameList = new ArrayList<String>();
            boolean isCandi = isAdmin;
            for (Object il : idList) {
                if (il.getGroupId() != null) {
                    if (!isCandi) {
                        if (userGroup == null) {
                            userGroup = this.processEngineConfiguration.getUserDataManager().findGroupsByUser(request.getEmployeeCode());
                        }
                        for (Group g : userGroup) {
                            if (!this.eq(g.getId(), il.getGroupId())) continue;
                            isCandi = true;
                            break;
                        }
                    }
                    nameList.add(this.getGroupName(il.getGroupId()));
                    continue;
                }
                if (il.getUserId() == null) continue;
                if (!isCandi && this.eq(request.getEmployeeCode(), il.getUserId())) {
                    isCandi = true;
                }
                nameList.add(this.getEmployeeName(il.getUserId()));
            }
            if (!isCandi && !this.hasRight(request.getEmployeeCode(), taskExt.getAssignee(), isAdmin)) {
                throw new WflSecurityException("wfl.security.error.need_assignee_or_admin");
            }
            taskExt.setAssigneeName(StringUtils.join((Object[])nameList.toArray(), (String)";"));
        }
        List attaList = this.taskService.getTaskAttachments(taskId);
        taskExt.setAttachments(attaList);
        TaskFormData formData = this.formService.getTaskFormData(taskId);
        taskExt.setFormData(this.restResponseFactory.createFormDataResponse((FormData)formData));
        List historicActivityInstanceList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).list();
        ArrayList<HistoricTaskInstanceResponseExt> list = new ArrayList<HistoricTaskInstanceResponseExt>();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstanceList) {
            this.setHistoricActivityInstanceResponseExt(historicActivityInstance, list, task.getProcessInstanceId(), request);
        }
        list.sort(Comparator.comparing(HistoricTaskInstanceResponse::getEndTime));
        taskExt.getHistoricTaskList().addAll(list);
        List comments = this.taskService.getTaskComments(task.getId(), "delegate_by");
        if (!comments.isEmpty()) {
            Comment comment = (Comment)comments.get(comments.size() - 1);
            TaskDelegate taskDelegate = new TaskDelegate();
            taskDelegate.setFromUserId(comment.getUserId());
            taskDelegate.setFromUserName(this.getEmployeeName(comment.getUserId()));
            taskDelegate.setTime(comment.getTime());
            taskDelegate.setReason(comment.getFullMessage());
            taskExt.setTaskDelegate(taskDelegate);
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        ProcessInstanceResponseExt processInstanceResp = (ProcessInstanceResponseExt)this.restResponseFactory.createProcessInstanceResponse(processInstance);
        processInstanceResp.setProcessDefinitionName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode(processInstanceResp.getProcessDefinitionName(), request));
        processInstanceResp.setStartUserName(this.getEmployeeName(processInstanceResp.getStartUserId()));
        taskExt.setProcessInstance(processInstanceResp);
        taskExt.setDescription(this.getProcessDescription(processInstance.getProcessDefinitionId(), taskExt.getExecutionId()));
        List vars = this.executionVariableCollectionResource.getVariables(task.getExecutionId(), null, this.fakeRequest);
        taskExt.setExecutionVariables(vars);
        return taskExt;
    }

    @Override
    public TaskResponseExt getTaskDetails(IRequest request, String taskId) throws WflSecurityException {
        return this.getTaskDetails(request, taskId, false);
    }

    @Override
    public DataResponse queryTaskList(IRequest iRequest, TaskQueryRequest taskQueryRequest, Map<String, String> requestParams) {
        DataResponse dataResponse = this.taskQueryResource.getQueryResult(taskQueryRequest, requestParams, this.fakeRequest);
        List list = (List)dataResponse.getData();
        for (TaskResponseExt taskResponse : list) {
            if (StringUtils.isNotEmpty((String)taskResponse.getOwner())) {
                taskResponse.setOwner(this.getEmployeeName(taskResponse.getOwner()));
            }
            if (StringUtils.isNotEmpty((String)taskResponse.getAssignee())) {
                taskResponse.setAssigneeName(this.getEmployeeName(taskResponse.getAssignee()));
            } else {
                List idList = this.taskService.getIdentityLinksForTask(taskResponse.getId());
                ArrayList<String> nameList = new ArrayList<String>();
                for (IdentityLink il : idList) {
                    if (il.getGroupId() != null) {
                        nameList.add(this.getGroupName(il.getGroupId()));
                        continue;
                    }
                    if (il.getUserId() == null) continue;
                    nameList.add(this.processApproveName(il.getUserId()));
                }
                taskResponse.setAssigneeName(StringUtils.join((Object[])nameList.toArray(), (String)";"));
            }
            ProcessInstance procInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(taskResponse.getProcessInstanceId()).list().iterator().next();
            taskResponse.setProcessName(procInstance.getProcessDefinitionName());
            taskResponse.setStartUserId(procInstance.getStartUserId());
            taskResponse.setStartUserName(this.getEmployeeName(procInstance.getStartUserId()));
            taskResponse.setDescription(this.getProcessDescription(procInstance.getProcessDefinitionId(), taskResponse.getExecutionId()));
            Date dueDate = taskResponse.getDueDate();
            if (dueDate != null) {
                Long dueTime = ActivitiUtils.secondsBetweenDate(taskResponse.getCreateTime(), dueDate);
                for (ICustomTaskProcessor processor : this.taskProcessors) {
                    taskResponse.setDueTime(processor.getDueTime(taskResponse.getCreateTime(), dueTime));
                    if (processor.processorContinue()) continue;
                    break;
                }
            }
            taskResponse.setProcessName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode(taskResponse.getProcessName(), iRequest));
            taskResponse.setName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode(taskResponse.getName(), iRequest));
        }
        return dataResponse;
    }

    @Override
    public DataResponse queryProcessInstances(IRequest iRequest, HistoricProcessInstanceQueryRequest historicProcessInstanceQueryRequest, Map<String, String> requestParams, boolean showRetract) {
        DataResponse dataResponse = this.historicProcessInstanceQueryResource.queryProcessInstances(historicProcessInstanceQueryRequest, requestParams, this.fakeRequest);
        for (HistoricProcessInstanceResponseExt his : (List)dataResponse.getData()) {
            List tasks;
            if (StringUtils.isNotEmpty((String)his.getStartUserId())) {
                his.setStartUserName(this.getEmployeeName(his.getStartUserId()));
            }
            if (StringUtils.isNotEmpty((String)his.getTaskDefKey())) {
                BpmnModel bpmnModel = this.repositoryService.getBpmnModel(his.getProcessDefinitionId());
                Collection flowElements = bpmnModel.getMainProcess().getFlowElements();
                Iterator iterator = flowElements.iterator();
                while (iterator.hasNext()) {
                    FlowElement flowElement = (FlowElement)iterator.next();
                    if (!his.getTaskDefKey().equals(flowElement.getId())) continue;
                    his.setTaskName(flowElement.getName());
                    break;
                }
            }
            List list1 = this.runtimeService.createExecutionQuery().processInstanceId(his.getId()).list();
            for (Execution ls : list1) {
                if (!ls.isSuspended()) continue;
                his.setSuspended(true);
                break;
            }
            if (!(tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(his.getId())).list()).isEmpty()) {
                Object[] currentApprovers = new String[tasks.size()];
                ArrayList<TaskInfo> currentTasks = new ArrayList<TaskInfo>();
                HashSet<String> taskName = new HashSet<String>();
                for (int i = 0; i < tasks.size(); ++i) {
                    Task task = (Task)tasks.get(i);
                    task.setName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode(task.getName(), iRequest));
                    taskName.add(task.getName());
                    currentApprovers[i] = this.getTaskApprove(task);
                    currentTasks.add(new TaskInfo(task.getId(), task.getName(), task.getAssignee(), this.getEmployeeName(task.getAssignee())));
                }
                his.setTaskName(org.springframework.util.StringUtils.collectionToCommaDelimitedString(taskName));
                his.setCurrentApprover(StringUtils.join((Object[])currentApprovers, (String)","));
                his.setCurrentTasks(currentTasks);
                his.setDescription(this.getProcessDescription(his.getProcessDefinitionId(), ((Task)tasks.iterator().next()).getExecutionId()));
            } else if (his.getEndTime() != null) {
                List variables = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(his.getId()).list();
                his.setDescription(this.getProcessDescription(his.getProcessDefinitionId(), variables.stream().collect(Collectors.toMap(key -> key.getVariableName(), value -> value.getValue() == null ? "" : value.getValue(), (existingValue, newValue) -> newValue))));
            }
            if (showRetract && his.getEndTime() == null) {
                his.setRecall(this.isStartRecall(his.getId(), iRequest.getEmployeeCode()) != false || this.isTaskRecall(his.getId(), iRequest.getEmployeeCode()) != false);
            }
            his.setProcessName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode(his.getProcessName(), iRequest));
        }
        return dataResponse;
    }

    private String getProcessDescription(String processDefinitionId, Map<String, Object> variables) {
        return this.getProcessDescription(processDefinitionId, null, variables);
    }

    private String getProcessDescription(String processDefinitionId, String executionId) {
        return this.getProcessDescription(processDefinitionId, executionId, null);
    }

    private String getProcessDescription(String processDefinitionId, String executionId, Map<String, Object> variables) {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        String description = bpmnModel.getMainProcess().getDocumentation();
        if (StringUtils.isNotEmpty((String)description)) {
            description = this.processEngineConfiguration.getCommandExecutor().execute((Command)new GetExpressionValueCmd(executionId, description, variables)).toString();
        }
        return description;
    }

    @Override
    public DataResponse queryHistoricTaskInstances(IRequest iRequest, HistoricTaskInstanceQueryRequest queryRequest, Map<String, String> allRequestParams) {
        if (allRequestParams == null) {
            allRequestParams = Collections.emptyMap();
        }
        List datas = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(queryRequest.getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().asc()).list();
        DataResponse dataResponse = new DataResponse();
        ArrayList<HistoricTaskInstanceResponseExt> list = new ArrayList<HistoricTaskInstanceResponseExt>();
        for (HistoricActivityInstance historicActivityInstance : datas) {
            this.setHistoricActivityInstanceResponseExt(historicActivityInstance, list, queryRequest.getProcessInstanceId(), iRequest);
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            HistoricTaskInstanceResponseExt i = (HistoricTaskInstanceResponseExt)((Object)it.next());
            if (null != i.getEndTime()) continue;
            it.remove();
        }
        boolean key = false;
        HistoricActivityInstance endDom = null;
        for (HistoricActivityInstance ext : datas) {
            if (ext.getDeleteReason() == null) continue;
            key = true;
            endDom = ext;
            break;
        }
        if (key) {
            HistoricTaskInstanceResponseExt ext = new HistoricTaskInstanceResponseExt();
            if ("RETRACT".equals(endDom.getDeleteReason())) {
                ext.setName("\u7528\u6237\u64a4\u9500");
            } else {
                ext.setName("\u7ba1\u7406\u5458\u5173\u95ed");
            }
            ext.setAction("\u7ec8\u6b62");
            ext.setEndTime(((HistoricActivityInstance)datas.get(datas.size() - 1)).getEndTime());
            list.add(ext);
        }
        dataResponse.setData(list);
        return dataResponse;
    }

    protected Task getTaskById(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new ActivitiObjectNotFoundException("Could not find a task with id '" + taskId + "'.", Task.class);
        }
        return task;
    }

    private void setHistoricActivityInstanceResponseExt(HistoricActivityInstance historicActivityInstance, List<HistoricTaskInstanceResponseExt> list, String processInstanceId, IRequest request) {
        String activityType = historicActivityInstance.getActivityType();
        if ("userTask".equals(activityType)) {
            List<Comment> comments = this.getCommentOfType(historicActivityInstance.getTaskId(), "comment");
            List<Comment> actions = this.getCommentOfType(historicActivityInstance.getTaskId(), "action");
            if (comments != null && comments.size() != 0) {
                for (int index = comments.size() - 1; index >= 0; --index) {
                    HistoricTaskInstanceResponseExt historicTaskInstanceResponseExt = new HistoricTaskInstanceResponseExt(historicActivityInstance);
                    CommentEntityImpl commentEntity = (CommentEntityImpl)comments.get(index);
                    historicTaskInstanceResponseExt.setComment(commentEntity.getMessage());
                    historicTaskInstanceResponseExt.setAction(actions.get(index).getFullMessage());
                    historicTaskInstanceResponseExt.setAssignee(actions.get(index).getUserId());
                    StringBuilder sb = new StringBuilder();
                    String temp = this.getEmployeeName(actions.get(index).getUserId());
                    sb.append(StringUtil.isEmpty(temp) ? "" : temp);
                    sb.append(StringUtil.isEmpty(actions.get(index).getUserId()) ? "" : "(" + actions.get(index).getUserId() + ")");
                    historicTaskInstanceResponseExt.setAssigneeName(sb.toString());
                    historicTaskInstanceResponseExt.setEndTime(actions.get(index).getTime());
                    historicTaskInstanceResponseExt.setName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode(historicTaskInstanceResponseExt.getName(), request));
                    list.add(historicTaskInstanceResponseExt);
                }
            }
            return;
        }
        HistoricTaskInstanceResponseExt historicTaskInstanceResponseExt = new HistoricTaskInstanceResponseExt(historicActivityInstance);
        if ("startEvent".equalsIgnoreCase(activityType) && StringUtil.isEmpty(historicActivityInstance.getActivityName())) {
            String startUser = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).list().get(0)).getStartUserId();
            historicTaskInstanceResponseExt.setAssignee(startUser);
            historicTaskInstanceResponseExt.setAssigneeName(this.getEmployeeName(startUser) + "(" + startUser + ")");
            String start = "\u5f00\u59cb";
            if (ActivitiMultiLanguageManager.multiLanguageOpen) {
                start = ActivitiMultiLanguageManager.getMultLanguageInfoByCode("hap.process.start", request);
            }
            historicTaskInstanceResponseExt.setName(start);
        }
        if ("endEvent".equalsIgnoreCase(activityType) && StringUtil.isEmpty(historicActivityInstance.getActivityName())) {
            String end = "\u7ed3\u675f";
            if (ActivitiMultiLanguageManager.multiLanguageOpen) {
                end = ActivitiMultiLanguageManager.getMultLanguageInfoByCode("hap.process.end", request);
            }
            historicTaskInstanceResponseExt.setName(end);
        }
        if (!("exclusiveGateway".equals(activityType) || "parallelGateway".equals(activityType) || "eventBasedGateway".equals(activityType) || "inclusiveGateway".equals(activityType) || null != historicActivityInstance.getDeleteReason())) {
            historicTaskInstanceResponseExt.setName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode(historicTaskInstanceResponseExt.getName(), request));
            list.add(historicTaskInstanceResponseExt);
        }
    }

    protected List<Comment> getCommentOfType(String taskId, String type) {
        List list = this.taskService.getTaskComments(taskId, type);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public void afterPropertiesSet() throws Exception {
        AutowireCapableBeanFactory autowireCapableBeanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        autowireCapableBeanFactory.autowireBean((Object)this.taskResource);
        autowireCapableBeanFactory.autowireBean((Object)this.executionVariableCollectionResource);
        autowireCapableBeanFactory.autowireBean((Object)this.taskQueryResource);
        autowireCapableBeanFactory.autowireBean((Object)this.historicProcessInstanceQueryResource);
        autowireCapableBeanFactory.autowireBean((Object)this.processInstanceCollectionResource);
        autowireCapableBeanFactory.autowireBean((Object)this.historicTaskInstanceQueryResource);
        autowireCapableBeanFactory.autowireBean((Object)this.historicProcessInstanceCollectionResource);
        autowireCapableBeanFactory.autowireBean((Object)this.deadLetterJobCollectionResource);
        Map listeners = this.applicationContext.getBeansOfType(ICustomTaskProcessor.class);
        this.taskProcessors = new ArrayList<ICustomTaskProcessor>();
        this.taskProcessors.addAll(listeners.values());
        Collections.sort(this.taskProcessors);
    }

    @Override
    public Boolean isStartRecall(String procId, String employeeCode) {
        List list = this.taskService.getProcessInstanceComments(procId);
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(procId).suspended().singleResult();
        String userId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procId).list().get(0)).getStartUserId();
        if (list.isEmpty() && null == processInstance && employeeCode.equalsIgnoreCase(userId)) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isTaskRecall(String procId, String employeeCode) {
        try {
            ProcessInstance suspendedProc = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(procId).suspended().singleResult();
            if (suspendedProc != null) {
                return false;
            }
            HistoricProcessInstance finishedProc = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(procId).finished().singleResult();
            if (finishedProc != null) {
                return false;
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procId)).list();
            if (tasks != null) {
                for (Task task : tasks) {
                    if (task.getOwner() == null) continue;
                    return false;
                }
            }
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(procId).orderByHistoricActivityInstanceStartTime().asc()).list();
            HistoricActivityInstance lastHistoricActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(historicActivityInstances.size() - 1);
            List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procId)).list();
            if (taskList.size() == 0) {
                return false;
            }
            String executionId = ((Task)taskList.iterator().next()).getExecutionId();
            Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(procId).executionId(executionId).singleResult();
            List childExecutionList = this.runtimeService.createExecutionQuery().processInstanceId(procId).parentId(execution.getParentId()).list();
            String activityId = lastHistoricActivityInstance.getActivityId();
            List activeExecutionList = this.runtimeService.createExecutionQuery().processInstanceId(procId).activityId(activityId).list();
            if (childExecutionList.size() > 1 && activeExecutionList.size() != childExecutionList.size()) {
                return false;
            }
            if ("userTask".equalsIgnoreCase(lastHistoricActivityInstance.getActivityType()) && lastHistoricActivityInstance.getEndTime() == null) {
                String multiActivityId = "";
                boolean isLastApprove = true;
                for (int i = historicActivityInstances.size() - 1; i >= 0; --i) {
                    HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(i);
                    String assignee = historicActivityInstance.getAssignee();
                    String activityType = historicActivityInstance.getActivityType();
                    if ("userTask".equalsIgnoreCase(activityType) && historicActivityInstance.getEndTime() == null || "parallelGateway".equalsIgnoreCase(activityType) || "exclusiveGateway".equalsIgnoreCase(activityType) || "eventBasedGateway".equalsIgnoreCase(activityType) || "inclusiveGateway".equalsIgnoreCase(activityType)) continue;
                    if (isLastApprove) {
                        if ("userTask".equalsIgnoreCase(activityType) && assignee != null && assignee.equalsIgnoreCase(employeeCode)) {
                            multiActivityId = historicActivityInstance.getActivityId();
                            isLastApprove = false;
                            String deleteReson = historicActivityInstance.getDeleteReason();
                            if ("jump".equalsIgnoreCase(deleteReson)) {
                                return false;
                            }
                            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicActivityInstance.getProcessDefinitionId());
                            FlowElement flowElement = bpmnModel.getMainProcess().getFlowElement(historicActivityInstance.getActivityId());
                            if (ActivitiUtils.isEnabledRevoke((UserTask)flowElement)) continue;
                            return false;
                        }
                        return false;
                    }
                    if (multiActivityId.equalsIgnoreCase(historicActivityInstance.getActivityId())) {
                        return false;
                    }
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    public void taskRecall(IRequest iRequest, String procId, String employeeCode) {
        List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(procId).activityType("userTask").orderByHistoricActivityInstanceStartTime().asc()).list();
        String taskId = ((HistoricActivityInstance)historicActivityInstances.get(historicActivityInstances.size() - 1)).getTaskId();
        String activityId = "";
        for (int i = historicActivityInstances.size() - 1; i >= 0; --i) {
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(i);
            String assignee = historicActivityInstance.getAssignee();
            String activityType = historicActivityInstance.getActivityType();
            if ("userTask".equalsIgnoreCase(activityType) && historicActivityInstance.getEndTime() == null) continue;
            if (!"userTask".equalsIgnoreCase(activityType) || !assignee.equalsIgnoreCase(employeeCode)) break;
            activityId = historicActivityInstance.getActivityId();
            break;
        }
        ProcessInstance procInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(procId).list().iterator().next();
        TaskRecallEvent event = new TaskRecallEvent(new TaskRecallInfo(procInstance, this.taskService.getVariables(taskId), employeeCode));
        event.setiRequest(iRequest);
        Authentication.setAuthenticatedUserId((String)employeeCode);
        this.taskService.addComment(taskId, procId, "action", "RECALL");
        this.taskService.addComment(taskId, procId, "comment", employeeCode + "\u64a4\u56de\u5ba1\u6279");
        JumpActivityCmd cmd = new JumpActivityCmd(taskId, activityId);
        this.processEngineConfiguration.getCommandExecutor().execute((Command)cmd);
        this.publisher.publishEvent((ApplicationEvent)event);
    }

    @Override
    public void startRecall(IRequest iRequest, String procId, String employeeCode) {
        String taskId = ((Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procId)).list().iterator().next()).getId();
        ProcessInstance procInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(procId).list().iterator().next();
        TaskRecallEvent event = new TaskRecallEvent(new TaskRecallInfo(procInstance, this.taskService.getVariables(taskId), employeeCode, true));
        event.setiRequest(iRequest);
        this.taskService.addComment(taskId, procId, "action", "RECALL");
        this.taskService.addComment(taskId, procId, "comment", employeeCode + "\u64a4\u56de\u5ba1\u6279");
        this.runtimeService.deleteProcessInstance(procId, "RETRACT");
        this.publisher.publishEvent((ApplicationEvent)event);
    }

    @Override
    public List<ProcessInstanceForecast> processInstanceForecast(IRequest request, String processInstanceId) {
        HashMap<String, ArrayList<HistoricTaskInstanceResponseExt>> history = new HashMap<String, ArrayList<HistoricTaskInstanceResponseExt>>();
        List historicActivityInstanceList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityType("userTask").orderByHistoricActivityInstanceEndTime().asc()).list();
        if (historicActivityInstanceList == null || historicActivityInstanceList.isEmpty()) {
            return null;
        }
        String processDefinitionId = ((HistoricActivityInstance)historicActivityInstanceList.get(0)).getProcessDefinitionId();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstanceList) {
            ArrayList<HistoricTaskInstanceResponseExt> list = new ArrayList<HistoricTaskInstanceResponseExt>();
            this.setHistoricActivityInstanceResponseExt(historicActivityInstance, list, processInstanceId, request);
            ArrayList<HistoricTaskInstanceResponseExt> value = (ArrayList<HistoricTaskInstanceResponseExt>)history.get(historicActivityInstance.getActivityId());
            if (value != null && !value.isEmpty()) {
                value.addAll(list);
            } else {
                value = list;
            }
            if (value.isEmpty()) continue;
            for (HistoricTaskInstanceResponseExt hisExt : value) {
                Employee employee = this.employeeService.queryInfoByCode(hisExt.getAssignee());
                hisExt.setPositionName(employee.getPositionName());
                hisExt.setUnitName(employee.getUnitName());
            }
            history.put(historicActivityInstance.getActivityId(), value);
        }
        ArrayList<ProcessInstanceForecast> processInstanceForecastList = new ArrayList<ProcessInstanceForecast>();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        boolean isFinish = false;
        HashMap forecastTask = new HashMap();
        if (executions == null || executions.isEmpty()) {
            isFinish = true;
        } else {
            Execution execution = (Execution)executions.get(executions.size() - 1);
            ForecastActivityCmd.executionId.set(execution.getId());
            for (Execution execution1 : executions) {
                List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).executionId(execution1.getId())).list();
                if (!CollectionUtils.isNotEmpty((Collection)tasks)) continue;
                tasks.forEach(task -> {
                    if (forecastTask.containsKey(task.getTaskDefinitionKey())) {
                        ((Set)forecastTask.get(task.getTaskDefinitionKey())).addAll(this.getTaskApproveInfo((Task)task));
                    } else {
                        forecastTask.put(task.getTaskDefinitionKey(), this.getTaskApproveInfo((Task)task));
                    }
                });
            }
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        for (UserTask flowNode : ((Process)bpmnModel.getProcesses().get(0)).findFlowElementsOfType(UserTask.class)) {
            List historyInfo;
            ProcessInstanceForecast forecast = new ProcessInstanceForecast();
            String key = flowNode.getId();
            forecast.setGraphicInfo(bpmnModel.getGraphicInfo(key));
            forecast.setTaskId(key);
            forecast.setTaskName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode(flowNode.getName(), request));
            if (isFinish) {
                forecast.setExecuted(true);
            }
            if ((historyInfo = (List)history.get(key)) != null) {
                HistoricTaskInstanceResponseExt info = (HistoricTaskInstanceResponseExt)((Object)historyInfo.get(0));
                if (!"RECALL".equalsIgnoreCase(info.getAction())) {
                    forecast.setExecuted(true);
                }
                if (forecastTask.containsKey(key)) {
                    forecast.setForecast((Set)forecastTask.get(key));
                }
                forecast.setHistory(historyInfo);
            }
            boolean needFrecast = !forecast.isExecuted();
            boolean isApproveChain = this.isApproveChain(flowNode, processDefinitionId);
            int executedCount = 0;
            if (isApproveChain && historyInfo != null) {
                boolean hasAddSign = false;
                for (HistoricTaskInstanceResponseExt index : historyInfo) {
                    if ("ADD_SIGN".equalsIgnoreCase(index.getAction())) {
                        hasAddSign = true;
                    }
                    if ("ADD_SIGN".equalsIgnoreCase(index.getAction()) || "DELEGATE".equalsIgnoreCase(index.getAction()) || "JUMP".equalsIgnoreCase(index.getAction()) || "RECALL".equalsIgnoreCase(index.getAction()) || "AUTO_DELEGATE".equalsIgnoreCase(index.getAction())) continue;
                    if (hasAddSign) {
                        hasAddSign = false;
                        continue;
                    }
                    ++executedCount;
                }
            }
            ForecastActivityCmd.executedCount.set(executedCount);
            if (needFrecast) {
                ForecastActivityCmd.userTask.set(flowNode);
                boolean unknown = false;
                Set approve = (Set)this.processEngineConfiguration.getCommandExecutor().execute((Command)this.forecastActivityCmd);
                if (approve == null || approve.isEmpty()) {
                    unknown = true;
                }
                if (forecast.getForecast() == null) {
                    forecast.setForecast(approve);
                } else if (!unknown) {
                    forecast.getForecast().addAll(approve);
                }
                ForecastActivityCmd.userTask.remove();
            }
            processInstanceForecastList.add(forecast);
        }
        if (ForecastActivityCmd.executionId.get() != null) {
            ForecastActivityCmd.executionId.remove();
        }
        if (ForecastActivityCmd.executedCount.get() != null) {
            ForecastActivityCmd.executedCount.remove();
        }
        return processInstanceForecastList;
    }

    private boolean isApproveChain(UserTask task, String processdefinitionid) {
        if (ActivitiUtils.isUseNewModelEditor(task) || !ActivitiUtils.isAddApproveChain(task)) {
            return false;
        }
        ApproveChainHeader approveChainHeader = this.approveChainHeaderService.selectByUserTask(StringUtils.substringBefore((String)processdefinitionid, (String)":"), task.getId());
        return approveChainHeader != null;
    }

    @Override
    public List<ActiviException> queryException(ActiviException exception, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        List<ActiviException> list = this.exceptionMapper.selectAllException(exception);
        return list;
    }

    @Override
    public void executeTaskByAdmin(IRequest request, String procId, TaskActionRequestExt taskActionRequest) throws TaskActionException {
        this.executeTaskAction(request, taskActionRequest.getCurrentTaskId(), taskActionRequest, true);
    }

    private String processApproveName(String userId) {
        String employeeName = this.getEmployeeName(userId);
        if (StringUtils.isNotEmpty((String)employeeName)) {
            return this.getEmployeeName(userId) + "(" + userId + ")";
        }
        return userId;
    }

    private String getTaskApprove(Task task) {
        if (StringUtils.isNotEmpty((String)task.getAssignee())) {
            return this.processApproveName(task.getAssignee());
        }
        List idList = this.taskService.getIdentityLinksForTask(task.getId());
        ArrayList<String> nameList = new ArrayList<String>();
        for (IdentityLink il : idList) {
            if (il.getGroupId() != null) {
                nameList.add(this.getGroupName(il.getGroupId()));
                continue;
            }
            if (il.getUserId() == null) continue;
            nameList.add(this.processApproveName(il.getUserId()));
        }
        return StringUtils.join((Object[])nameList.toArray(), (String)";");
    }

    private Set<Employee> getTaskApproveInfo(Task task) {
        LinkedHashSet<Employee> employees = new LinkedHashSet<Employee>();
        if (StringUtils.isNotEmpty((String)task.getAssignee())) {
            Employee e = this.employeeService.queryInfoByCode(task.getAssignee());
            if (e != null) {
                employees.add(e);
            }
        } else {
            List idList = this.taskService.getIdentityLinksForTask(task.getId());
            for (IdentityLink il : idList) {
                Employee e;
                if (il.getGroupId() != null) {
                    List<Employee> emps = this.employeeService.selectByPostionCode(il.getGroupId());
                    employees.addAll(emps);
                    continue;
                }
                if (il.getUserId() == null || (e = this.employeeService.queryInfoByCode(il.getUserId())) == null) continue;
                employees.add(e);
            }
        }
        return employees;
    }
}

