/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.listeners;

import com.hand.hap.activiti.listeners.IUserTaskNotifier;
import com.hand.hap.core.AppContextInitListener;
import com.hand.hap.message.IMessagePublisher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.activiti.engine.impl.persistence.entity.data.GroupDataManager;
import org.activiti.engine.impl.persistence.entity.data.UserDataManager;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class NotificationListener
implements TaskListener,
AppContextInitListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserDataManager userDataManager;
    @Autowired
    private GroupDataManager groupDataManager;
    @Autowired
    private IMessagePublisher messagePublisher;
    private FormService formService;
    private HistoryService historyService;
    private Collection<IUserTaskNotifier> notifiers = Collections.emptyList();

    public void notify(DelegateTask delegateTask) {
        if ("create".equals(delegateTask.getEventName())) {
            TaskEntity task = (TaskEntity)delegateTask;
            String assignee = task.getAssignee();
            List identityLinks = task.getIdentityLinks();
            if (StringUtils.isNotEmpty((String)assignee)) {
                UserEntity user = (UserEntity)this.userDataManager.findById(assignee);
                this.sendNotification(user, task);
            }
            for (IdentityLinkEntity link : identityLinks) {
                if (!"candidate".equals(link.getType())) continue;
                if (link.isUser()) {
                    UserEntity user = (UserEntity)this.userDataManager.findById(link.getUserId());
                    this.sendNotification(user, task);
                }
                if (!link.isGroup()) continue;
                this.sendNotification((GroupEntity)this.groupDataManager.findById(link.getGroupId()), task);
            }
        } else if ("complete".equals(delegateTask.getEventName())) {
            String approveResult;
            List properties = this.formService.getTaskFormData(delegateTask.getId()).getFormProperties();
            boolean autoCC = false;
            if (properties != null) {
                for (FormProperty property : properties) {
                    if (!"ACT_AUTO_CARBON_COPY".equals(property.getId()) || !"Y".equals(property.getName())) continue;
                    autoCC = true;
                    break;
                }
            }
            if (autoCC && StringUtils.equals((String)"REJECTED", (String)(approveResult = delegateTask.getVariable("approveResult").toString()))) {
                List history = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(delegateTask.getProcessInstanceId())).list();
                HashSet users = new HashSet();
                history.forEach(t -> {
                    if (!delegateTask.getAssignee().equals(t.getAssignee())) {
                        users.add(t.getAssignee());
                    }
                });
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("processInstanceId", delegateTask.getProcessInstanceId());
                params.put("users", users);
                this.messagePublisher.message("wfl.carbon.copy", params);
            }
        }
    }

    public void sendNotification(GroupEntity groupEntity, TaskEntity taskEntity) {
        this.log.debug("send email notification to group:" + groupEntity);
        for (IUserTaskNotifier notifier : this.notifiers) {
            notifier.onTaskCreate(taskEntity, groupEntity);
        }
    }

    public void sendNotification(UserEntity user, TaskEntity task) {
        this.log.debug("send email notification to user:" + user);
        for (IUserTaskNotifier notifier : this.notifiers) {
            notifier.onTaskCreate(task, user);
        }
        if (user == null) {
            throw new ActivitiException("Employee Not Found.");
        }
        String message = user.getFirstName() + " \u4f60\u597d:<br/>\u4f60\u6709\u4e00\u4e2a\u5de5\u4f5c\u6d41\u9700\u8981\u5ba1\u6279.";
        this.log.debug(message);
    }

    protected void setMailServerProperties(Email email) throws EmailException {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        String host = processEngineConfiguration.getMailServerHost();
        if (host == null) {
            throw new ActivitiException("Could not send email: no SMTP host is configured");
        }
        email.setHostName(host);
        int port = processEngineConfiguration.getMailServerPort();
        email.setSmtpPort(port);
        String user = processEngineConfiguration.getMailServerUsername();
        String password = processEngineConfiguration.getMailServerPassword();
        if (user != null && password != null) {
            email.setFrom(user);
            email.setAuthentication(user, password);
        }
    }

    @Override
    public void contextInitialized(ApplicationContext applicationContext) {
        Map map = applicationContext.getBeansOfType(IUserTaskNotifier.class);
        this.notifiers = map.values();
        this.historyService = (HistoryService)applicationContext.getBean(HistoryService.class);
        this.formService = (FormService)applicationContext.getBean(FormService.class);
    }
}

