/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.controllers;

import com.hand.hap.activiti.components.ActivitiMultiLanguageManager;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import io.swagger.annotations.ApiParam;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.image.ProcessDiagramGenerator;
import org.activiti.rest.service.api.repository.BaseProcessDefinitionResource;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/wfl", "/api/wfl"})
public class ProcessDefinitionImageRestResource
extends BaseProcessDefinitionResource {
    @Autowired
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}/image"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> getModelResource(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId, HttpServletRequest request) {
        IRequest iRequest = RequestHelper.createServiceRequest(request);
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        InputStream imageStream = null;
        if (!ActivitiMultiLanguageManager.multiLanguageOpen) {
            imageStream = this.repositoryService.getProcessDiagram(processDefinition.getId());
        } else if (processDefinition != null && processDefinition.hasGraphicalNotation()) {
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
            ProcessDiagramGenerator diagramGenerator = this.processEngineConfiguration.getProcessDiagramGenerator();
            HashMap<String, String> oldFlowNodeName = new HashMap<String, String>();
            List flowNodes = bpmnModel.getMainProcess().findFlowElementsOfType(FlowNode.class);
            for (FlowNode flowNode : flowNodes) {
                oldFlowNodeName.put(flowNode.getId(), flowNode.getName());
                flowNode.setName(ActivitiMultiLanguageManager.getMultLanguageInfoByCode(flowNode.getName(), iRequest));
            }
            imageStream = diagramGenerator.generateDiagram(bpmnModel, "png", new ArrayList(), new ArrayList(), this.processEngineConfiguration.getActivityFontName(), this.processEngineConfiguration.getLabelFontName(), this.processEngineConfiguration.getAnnotationFontName(), this.processEngineConfiguration.getClassLoader(), 1.0);
            for (FlowNode flowNode : flowNodes) {
                flowNode.setName((String)oldFlowNodeName.get(flowNode.getId()));
            }
        }
        if (imageStream != null) {
            HttpHeaders responseHeaders = new HttpHeaders();
            responseHeaders.set("Content-Type", "image/png");
            try {
                return new ResponseEntity((Object)IOUtils.toByteArray((InputStream)imageStream), (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
            catch (Exception e) {
                throw new ActivitiException("Error reading image stream", (Throwable)e);
            }
        }
        throw new ActivitiIllegalArgumentException("Process definition with id '" + processDefinition.getId() + "' has no image.");
    }
}

