/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.account.controllers;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.UserException;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.account.service.IUserInfoService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.function.dto.ResourceItemAssign;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/user", "/api/sys/user"})
public class UserController
extends BaseController {
    @Autowired
    private IUserService userService;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IUserInfoService userInfoService;

    @PostMapping(value={"/submitResourceItems"})
    public ResponseData submitResourceItems(HttpServletRequest request, @RequestBody List<ResourceItemAssign> resourceItemAssignList, @RequestParam(required=false) Long userId, @RequestParam(required=false) Long functionId) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.userService.updateResourceItemAssign(requestContext, resourceItemAssignList, userId, functionId));
    }

    @PostMapping(value={"/deleteResourceItems"})
    public ResponseData removeResourceItems(@RequestParam(required=false) Long userId, @RequestParam(required=false) Long functionId) {
        this.userService.deleteResourceItems(userId, functionId);
        return new ResponseData();
    }

    @PostMapping(value={"/queryResourceItems"})
    public ResponseData queryResourceItems(HttpServletRequest request, @RequestParam(required=false) Long userId, @RequestParam(required=false) Long functionId) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.userService.queryResourceItems(requestContext, userId, functionId));
    }

    @PostMapping(value={"/queryFunction"})
    public ResponseData queryFunction(HttpServletRequest request, @RequestParam(required=false) Long userId) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.userService.queryFunction(requestContext, userId));
    }

    @PostMapping(value={"/query"})
    public ResponseData queryUsers(HttpServletRequest request, @ModelAttribute User user, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.userService.selectUsers(iRequest, user, page, pagesize));
    }

    @PostMapping(value={"/submit"})
    public ResponseData submitUsers(@RequestBody List<User> users, BindingResult result, HttpServletRequest request) throws BaseException {
        this.getValidator().validate(users, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        return new ResponseData(this.userService.batchUpdate(this.createRequestContext(request), users));
    }

    @PostMapping(value={"/update"})
    public ResponseData updateUserInfo(HttpServletRequest request, @RequestBody User user) throws BaseException {
        IRequest iRequest = this.createRequestContext(request);
        this.userInfoService.update(iRequest, user);
        return new ResponseData(Collections.singletonList(user));
    }

    @PostMapping(value={"/remove"})
    public ResponseData remove(@RequestBody List<User> users) throws BaseException {
        this.userService.batchDelete(users);
        return new ResponseData(users);
    }

    @PostMapping(value={"/{userId}/roles"})
    public ResponseData queryUserAndRoles(HttpServletRequest request, @PathVariable Long userId) {
        IRequest iRequest = this.createRequestContext(request);
        ResponseData rd = new ResponseData();
        User user = new User();
        user.setUserId(userId);
        rd.setRows(this.roleService.selectRolesByUser(iRequest, user));
        return rd;
    }

    @PostMapping(value={"/password/reset"})
    public ResponseData updatePassword(HttpServletRequest request, String password, String passwordAgain, Long userId) throws UserException {
        IRequest iRequest = this.createRequestContext(request);
        User user = new User();
        user.setUserId(userId);
        user.setPassword(password);
        this.userService.resetPassword(iRequest, user, passwordAgain);
        return new ResponseData(true);
    }

    @PostMapping(value={"/password/update"})
    public ResponseData updatePassword(HttpServletRequest request, String oldPwd, String newPwd, String newPwdAgain) throws UserException {
        IRequest iRequest = this.createRequestContext(request);
        this.userService.updateOwnerPassword(iRequest, oldPwd, newPwd, newPwdAgain);
        return new ResponseData(true);
    }
}

