/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.account.controllers;

import com.hand.hap.account.dto.Role;
import com.hand.hap.account.dto.RoleExt;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/role", "/api/sys/role"})
public class RoleController
extends BaseController {
    @Autowired
    @Qualifier(value="roleServiceImpl")
    private IRoleService roleService;

    @RequestMapping(value={"/queryRoleNotUserRole"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData queryRoleNotUserRoles(HttpServletRequest request, RoleExt roleExt, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.roleService.selectRoleNotUserRoles(requestContext, roleExt, page, pagesize));
    }

    @RequestMapping(value={"/query"}, method={RequestMethod.POST, RequestMethod.GET})
    public ResponseData queryRoles(Role role, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.roleService.selectRoles(requestContext, role, page, pagesize));
    }

    @PostMapping(value={"/submit"})
    public ResponseData submitRole(@RequestBody List<Role> roles, BindingResult result, HttpServletRequest request) throws BaseException {
        this.getValidator().validate(roles, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.roleService.batchUpdate(requestContext, roles));
    }

    @PostMapping(value={"/remove"})
    public ResponseData removeRole(HttpServletRequest request, @RequestBody List<Role> roles) throws BaseException {
        this.roleService.batchDelete(roles);
        return new ResponseData();
    }
}

