/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.task.components;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import com.hand.hap.core.AppContextInitListener;
import com.hand.hap.task.log.TaskAppender;
import com.hand.hap.task.log.TaskLogFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class LogbackDynamicConfig
implements AppContextInitListener {
    @Value(value="${task.execute.log.level:INFO}")
    private String logLevel;

    public void contextInitialized(ApplicationContext applicationContext) {
        try {
            this.addAppender();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addAppender() throws IOException {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logger = lc.getLogger("root");
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setCharset(Charset.forName("UTF-8"));
        encoder.setPattern("%d{yyyy-MM-dd HH:mm:ss.SSS} %-5level [%X{userId}] [%X{requestId}] %logger - %msg%n");
        encoder.setImmediateFlush(true);
        encoder.setContext((Context)lc);
        encoder.start();
        TaskLogFilter taskLogFilter = new TaskLogFilter();
        taskLogFilter.start();
        ThresholdFilter thresholdFilter = new ThresholdFilter();
        thresholdFilter.setLevel(this.logLevel);
        thresholdFilter.start();
        TaskAppender appender = new TaskAppender();
        appender.setEncoder((Encoder)encoder);
        appender.setName("TASK");
        appender.addFilter((Filter)taskLogFilter);
        appender.addFilter((Filter)thresholdFilter);
        appender.setContext((Context)lc);
        appender.start();
        logger.addAppender((Appender)appender);
    }
}

