/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.hand.hap.cache.impl.LovCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.IRequestAware;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.mybatis.util.SqlMapper;
import com.hand.hap.system.dto.DTOClassInfo;
import com.hand.hap.system.dto.Lov;
import com.hand.hap.system.dto.LovItem;
import com.hand.hap.system.mapper.LovItemMapper;
import com.hand.hap.system.mapper.LovMapper;
import com.hand.hap.system.service.ILovService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.hand.hap.system.service.impl.LovServiceImpl;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LovServiceImpl
extends BaseServiceImpl<Lov>
implements ILovService {
    private final Logger logger = LoggerFactory.getLogger(LovServiceImpl.class);
    @Autowired
    @Qualifier(value="sqlSessionFactory")
    private SqlSessionFactory sqlSessionFactory;
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LovMapper lovMapper;
    @Autowired
    private LovItemMapper lovItemMapper;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private LovCache lovCache;

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<Lov> selectLovs(IRequest request, Lov lov, int page, int pagesize) {
        PageHelper.startPage((int)page, (int)pagesize);
        return this.lovMapper.selectLovs(lov);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public Lov loadLov(Long lovId) {
        return (Lov)this.lovMapper.selectByPrimaryKey((Object)lovId);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Lov> batchUpdate(IRequest request, @StdWho List<Lov> lovs) {
        for (Lov lov : lovs) {
            if (lov.getLovId() == null) {
                ((ILovService)this.self()).createLov(lov);
                continue;
            }
            if (lov.getLovId() == null) continue;
            ((ILovService)this.self()).updateLov(lov);
        }
        return lovs;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean batchDeleteLov(List<Lov> items) {
        for (Lov lov : items) {
            int updateCount = this.lovMapper.deleteByPrimaryKey((Object)lov);
            this.checkOvn(updateCount, (Object)lov);
            this.lovItemMapper.deleteByLovId(lov.getLovId());
            this.lovCache.remove(lov.getCode());
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean batchDeleteItems(List<LovItem> items) {
        for (LovItem item : items) {
            ((ILovService)this.self()).deleteLovItem(item);
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean deleteLovItem(LovItem item) {
        int updateCount = this.lovItemMapper.deleteByPrimaryKey((Object)item);
        this.checkOvn(updateCount, (Object)item);
        if (1 == updateCount) {
            this.lovCache.reload(item.getLovId());
            return true;
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public Lov createLov(Lov lov) {
        this.lovMapper.insertSelective((Object)lov);
        if (lov.getLovItems() != null) {
            for (LovItem lovItem : lov.getLovItems()) {
                lovItem.setLovId(lov.getLovId());
                this.lovItemMapper.insertSelective((Object)lovItem);
            }
        }
        this.lovCache.reload(lov.getLovId());
        return lov;
    }

    @Transactional(rollbackFor={Exception.class})
    public Lov updateLov(Lov lov) {
        int updateCount = this.lovMapper.updateByPrimaryKeySelective((Object)lov);
        this.checkOvn(updateCount, (Object)lov);
        if (lov.getLovItems() != null) {
            for (LovItem lovItem : lov.getLovItems()) {
                if (lovItem.getLovItemId() == null) {
                    lovItem.setLovId(lov.getLovId());
                    this.lovItemMapper.insertSelective((Object)lovItem);
                    continue;
                }
                this.lovItemMapper.updateByPrimaryKeySelective((Object)lovItem);
            }
        }
        this.lovCache.reload(lov.getLovId());
        return lov;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<LovItem> selectLovItems(IRequest request, LovItem lovItem) {
        return this.lovItemMapper.selectByLovId(lovItem.getLovId());
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public String getLov(String contextPath, Locale locale, String lovCode) {
        LovEditor editor = this.getLovEditor(contextPath, locale, lovCode);
        try {
            return this.objectMapper.writeValueAsString((Object)editor);
        }
        catch (JsonProcessingException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            return "''";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<?> selectDatas(IRequest request, String code, Object obj, int page, int pagesize) {
        int n;
        Class<?>[] classArray;
        String beanName;
        Lov lov = this.lovCache.getValue(code);
        String sqlId = lov.getSqlId();
        String customSql = lov.getCustomSql();
        String customUrl = lov.getCustomUrl();
        if (StringUtils.isNotEmpty((String)sqlId)) {
            Class<?>[] interfaceClass;
            beanName = StringUtils.uncapitalize((String)StringUtils.substringBefore((String)lov.getSqlId(), (String)"."));
            Object mapperObjectDelegate = this.beanFactory.getBean(beanName);
            if (mapperObjectDelegate == null) {
                return Collections.emptyList();
            }
            classArray = interfaceClass = mapperObjectDelegate.getClass().getInterfaces();
            n = classArray.length;
        } else {
            if (!StringUtils.isNotEmpty((String)customSql)) return Collections.emptyList();
            try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
                PageHelper.startPage((int)page, (int)pagesize);
                SqlMapper sqlMapper = new SqlMapper(sqlSession);
                if (obj instanceof Map) {
                    ((Map)obj).put("request", request);
                }
                List preResults = sqlMapper.selectList("<script>\n\t" + customSql + "</script>", obj, HashMap.class);
                Page results = new Page();
                results.setTotal(((Page)preResults).getTotal());
                for (HashMap m0 : preResults) {
                    HashMap map = new HashMap(16);
                    m0.forEach((k, v) -> map.put(DTOClassInfo.underLineToCamel((String)((String)k)), v));
                    results.add(map);
                }
                Page page2 = results;
                return page2;
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) return Collections.emptyList();
                this.logger.error(e.getMessage(), e);
            }
            return Collections.emptyList();
        }
        for (int i = 0; i < n; ++i) {
            Class<?> c = classArray[i];
            if (!c.getSimpleName().equalsIgnoreCase(beanName)) continue;
            sqlId = c.getPackage().getName() + "." + StringUtils.capitalize((String)lov.getSqlId());
            break;
        }
        try (SqlSession sqlSession2 = this.sqlSessionFactory.openSession();){
            PageHelper.startPage((int)page, (int)pagesize);
            obj = this.convertMapParamToDtoParam(sqlSession2, sqlId, obj);
            if (obj instanceof IRequestAware) {
                ((IRequestAware)obj).setRequest(request);
            } else if (obj instanceof Map) {
                ((Map)obj).put("request", request);
            }
            List list = sqlSession2.selectList(sqlId, obj);
            return list;
        }
        catch (Throwable e) {
            if (!this.logger.isErrorEnabled()) return Collections.emptyList();
            this.logger.error(e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    private LovEditor getLovEditor(String contextPath, Locale locale, String lovCode) {
        Lov lov = this.lovCache.getValue(lovCode);
        if (lov == null && (lov = this.lovMapper.selectByCode(lovCode)) != null) {
            List items = this.lovItemMapper.selectByLovId(lov.getLovId());
            lov.setLovItems(items);
            this.lovCache.setValue(lov.getCode(), lov);
        }
        return lov != null ? this.createLovEditor(contextPath, locale, lov, lov.getLovItems()) : null;
    }

    private Object convertMapParamToDtoParam(SqlSession sqlSession, String sqlId, Object map) {
        if (!(map instanceof Map)) {
            this.logger.warn("lov query parameter is not a map:{}", map);
            return map;
        }
        MappedStatement statement = sqlSession.getConfiguration().getMappedStatement(sqlId);
        if (statement == null) {
            this.logger.warn("no statement found for sqlId:{}", (Object)sqlId);
            return map;
        }
        List resultMaps = statement.getResultMaps();
        if (resultMaps == null || resultMaps.isEmpty()) {
            this.logger.warn("statement has no specified ResultMap, sqlId:{}", (Object)sqlId);
            return map;
        }
        ResultMap resultMap = (ResultMap)resultMaps.get(0);
        try {
            Class dtoClass = resultMap.getType();
            Object dto = dtoClass.newInstance();
            if (dto instanceof Map) {
                return map;
            }
            ((Map)map).forEach((k, v) -> {
                try {
                    PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor((Object)dto, (String)((String)k));
                    if (desc != null) {
                        BeanUtils.setProperty((Object)dto, (String)((String)k), (Object)v);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            this.logger.debug("convert lov query parameter to {}", dto);
            return dto;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private LovEditor createLovEditor(String contextPath, Locale locale, Lov lov, List<LovItem> items) {
        LovEditor editor = new LovEditor(this, lov, locale);
        editor.setGrid(new LovGrid(this, contextPath, locale, lov, items));
        editor.setCondition(new LovCondition(this, contextPath, locale, lov, items));
        return editor;
    }

    static /* synthetic */ MessageSource access$000(LovServiceImpl x0) {
        return x0.messageSource;
    }

    static /* synthetic */ LovEditor access$100(LovServiceImpl x0, String x1, Locale x2, String x3) {
        return x0.getLovEditor(x1, x2, x3);
    }
}

