/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.service.impl;

import com.hand.hap.account.service.IUserService;
import com.hand.hap.cache.impl.ResourceItemCache;
import com.hand.hap.cache.impl.ResourceItemElementCache;
import com.hand.hap.cache.impl.RoleResourceItemCache;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.dto.ResourceItem;
import com.hand.hap.function.dto.ResourceItemElement;
import com.hand.hap.function.mapper.RoleFunctionMapper;
import com.hand.hap.function.service.IResourceService;
import com.hand.hap.system.service.IAccessService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.logstash.logback.encoder.org.apache.commons.lang.ArrayUtils;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Scope(value="prototype")
public class AccessServiceImpl
implements IAccessService {
    private static final String ACTION_MAINTAIN = "MAINTAIN";
    private Logger logger = LoggerFactory.getLogger(AccessServiceImpl.class);
    private HttpServletRequest request;
    @Autowired
    private IResourceService resourceService;
    @Autowired
    private RoleFunctionMapper roleFunctionMapper;
    @Autowired
    private ResourceItemCache resourceItemCache;
    @Autowired
    private RoleResourceItemCache roleResourceItemCache;
    @Autowired
    private ResourceItemElementCache resourceItemElementCache;
    @Autowired
    private IUserService userService;

    public boolean accessMaintain() {
        return ((IAccessService)this.self()).access(ACTION_MAINTAIN);
    }

    public boolean access(String accessCode) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String requestUri = request.getRequestURI();
        String contextPath = request.getContextPath();
        String url = requestUri.substring(contextPath.length() + 1);
        Resource resource = this.resourceService.selectResourceByUrl(url);
        boolean accessFlag = false;
        if (resource != null) {
            Object[] resourceItems = this.resourceItemCache.getValue(resource.getResourceId().toString());
            if (ArrayUtils.isEmpty((Object[])resourceItems)) {
                return accessFlag;
            }
            Object[] roleResourceItemIds = this.roleResourceItemCache.getValue(this.getRoleId().toString());
            if (ArrayUtils.isEmpty((Object[])roleResourceItemIds)) {
                return accessFlag;
            }
            Long accessResourceItemId = null;
            for (Object resourceItem : resourceItems) {
                if (!resourceItem.getItemId().equals(accessCode)) continue;
                accessResourceItemId = resourceItem.getResourceItemId();
                break;
            }
            accessFlag = Arrays.asList(roleResourceItemIds).contains(accessResourceItemId);
        }
        return accessFlag;
    }

    public String accessData() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String requestUri = request.getRequestURI();
        String contextPath = request.getContextPath();
        String url = requestUri.substring(contextPath.length() + 1);
        Resource resource = this.resourceService.selectResourceByUrl(url);
        HashMap accessData = new HashMap(3);
        if (resource == null) {
            return ((Object)accessData).toString();
        }
        Object[] resourceItems = this.resourceItemCache.getValue(resource.getResourceId().toString());
        if (ArrayUtils.isEmpty((Object[])resourceItems)) {
            return ((Object)accessData).toString();
        }
        List assignElementIds = this.userService.getAllAssignElementIds(this.getUserId(), Arrays.asList(this.getRoleIds()));
        if (CollectionUtils.isEmpty((Collection)assignElementIds)) {
            return ((Object)accessData).toString();
        }
        return this.buildAccessData(accessData, (ResourceItem[])resourceItems, assignElementIds);
    }

    public boolean accessFunction(String functionCode) {
        Long roleId = this.getRoleId();
        int result = this.roleFunctionMapper.selectCountByFunctionCode(roleId, functionCode);
        return result > 0;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    private String buildAccessData(Map accessData, ResourceItem[] resourceItems, List<Long> assignElementIds) {
        accessData.put("buttons", new ArrayList());
        accessData.put("grid", new ArrayList());
        accessData.put("form", new ArrayList());
        for (ResourceItem resourceItem : resourceItems) {
            Object[] elements = this.resourceItemElementCache.getValue(resourceItem.getResourceItemId().toString());
            if (!ArrayUtils.isNotEmpty((Object[])elements)) continue;
            for (Object element : elements) {
                if (!assignElementIds.contains(element.getElementId())) continue;
                this.buildElements(resourceItem, (ResourceItemElement)element, accessData);
            }
        }
        return JSONObject.fromObject((Object)accessData).toString();
    }

    private void buildElements(ResourceItem resourceItem, ResourceItemElement element, Map accessData) {
        String type = resourceItem.getItemType();
        String itemId = resourceItem.getItemId();
        if ("buttons".equalsIgnoreCase(type)) {
            this.buildElement(element.getProperty(), element.getPropertyValue(), accessData, "buttons");
        } else if ("form".equalsIgnoreCase(type)) {
            List formList = (List)accessData.get("form");
            Map form = null;
            for (Map map : formList) {
                String id = (String)map.get("id");
                if (!id.equals(itemId)) continue;
                form = map;
                break;
            }
            if (form == null) {
                form = new HashMap<String, Object>(3);
                form.put("id", itemId);
                form.put("fields", new ArrayList());
                form.put("buttons", new ArrayList());
                formList.add(form);
            }
            if ("form-buttons".equalsIgnoreCase(element.getType())) {
                this.buildElement(element.getProperty(), element.getPropertyValue(), form, "fields");
            } else if ("form-field".equalsIgnoreCase(element.getType())) {
                this.buildElement(element.getProperty(), element.getPropertyValue(), form, "buttons");
            }
        } else if ("grid".equalsIgnoreCase(type)) {
            List gridList = (List)accessData.get("grid");
            Map grid = null;
            for (Map map : gridList) {
                String id = (String)map.get("id");
                if (!id.equals(itemId)) continue;
                grid = map;
                break;
            }
            if (grid == null) {
                grid = new HashMap<String, Object>(4);
                grid.put("id", itemId);
                grid.put("buttons", new ArrayList());
                grid.put("columnButtons", new ArrayList());
                grid.put("columns", new ArrayList());
                gridList.add(grid);
            }
            if ("grid-buttons".equalsIgnoreCase(element.getType())) {
                this.buildElement(element.getProperty(), element.getPropertyValue(), grid, "buttons");
            } else if ("column-buttons".equalsIgnoreCase(element.getType())) {
                this.buildElement(element.getProperty(), element.getPropertyValue(), grid, "columnButtons");
            } else if ("column".equalsIgnoreCase(element.getType())) {
                this.buildElement(element.getProperty(), element.getPropertyValue(), grid, "columns");
            }
        }
    }

    private void buildElement(String property, String propertyValue, Map accessData, String type) {
        List mapList = (List)accessData.get(type);
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(property, propertyValue);
        mapList.add(map);
    }

    private Long getUserId() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return (Long)session.getAttribute("userId");
        }
        return null;
    }

    private Long getRoleId() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return (Long)session.getAttribute("roleId");
        }
        return null;
    }

    private Long[] getRoleIds() {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            return (Long[])session.getAttribute("roleIds");
        }
        return null;
    }
}

