/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers.sys;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.Form;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.IFormBuilderService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class FormBuilderController
extends BaseController {
    @Autowired
    private IFormBuilderService service;

    @RequestMapping(value={"sys/form/builder/query"})
    @ResponseBody
    public ResponseData queryAll(Form builder, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, (Object)builder, page, pageSize));
    }

    @RequestMapping(value={"sys/form/builder/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<Form> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"sys/form/builder/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<Form> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/form/{name}"})
    public ModelAndView renderView(@PathVariable String name, Model model) {
        return new ModelAndView(name + ".form");
    }

    @RequestMapping(value={"/form_preview"})
    public ModelAndView previewView(@RequestParam String code, Model model) {
        return new ModelAndView("preview/" + code + ".form");
    }
}

