/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.system.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.dto.Shortcut;
import com.hand.hap.system.service.IShortcutService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ShortcutController
extends BaseController {
    @Autowired
    private IShortcutService service;

    @RequestMapping(value={"/sys/shortcut/query"})
    @ResponseBody
    public ResponseData query(HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.selectMyShortcutFunction(requestContext.getUserId()));
    }

    @RequestMapping(value={"/sys/shortcut/submit"})
    @ResponseBody
    public ResponseData update(HttpServletRequest request, String functionCode) {
        Shortcut shortcuts;
        IRequest requestContext = this.createRequestContext(request);
        List shortcutList = this.service.select(requestContext, (Object)(shortcuts = new Shortcut(requestContext.getUserId(), functionCode)), 1, 10);
        if (!shortcutList.isEmpty()) {
            return null;
        }
        this.service.insert(requestContext, (Object)shortcuts);
        return new ResponseData();
    }

    @RequestMapping(value={"/sys/shortcut/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, String shortcutId) {
        Shortcut shortcut = new Shortcut();
        shortcut.setShortcutId(Long.valueOf(Long.parseLong(shortcutId)));
        this.service.deleteByPrimaryKey((Object)shortcut);
        return new ResponseData();
    }
}

