/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.security;

import com.hand.hap.core.BaseConstants;
import com.hand.hap.core.components.SysConfigManager;
import com.hand.hap.core.components.UserLoginInfoCollection;
import com.hand.hap.security.AuthenticationRequestContextFilter;
import com.hand.hap.security.CustomUserDetails;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

public class CustomAuthenticationProvider
extends DaoAuthenticationProvider
implements BaseConstants {
    private static ThreadLocal<String> clientId = new ThreadLocal();
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private SysConfigManager sysConfigManager;
    private String redisCatalog = "hap:cache:authentication_limit:";

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        Object salt = null;
        if (this.getSaltSource() != null) {
            salt = this.getSaltSource().getSalt(userDetails);
        }
        if (authentication.getCredentials() == null) {
            this.logger.debug((Object)"Authentication failed: no credentials provided");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        String redisKey = this.getRedisKey(userDetails);
        this.isAuthenticationLimit(userDetails, redisKey);
        String presentedPassword = authentication.getCredentials().toString();
        if (!this.getPasswordEncoder().isPasswordValid(userDetails.getPassword(), presentedPassword, salt)) {
            this.passwordErrorLimitCount(redisKey);
            this.logger.debug((Object)"Authentication failed: password does not match stored value");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        this.passwordLimitCountReset(redisKey);
    }

    public String getRedisKey(UserDetails userDetails) {
        HttpServletRequest request = (HttpServletRequest)AuthenticationRequestContextFilter.HTTP_SERVLET_REQUEST.get();
        String ip = UserLoginInfoCollection.getIpAddress((HttpServletRequest)request);
        String redisKey = this.redisCatalog + ip + "_";
        if (userDetails instanceof CustomUserDetails) {
            String clientIdStr = (String)clientId.get();
            redisKey = redisKey + clientIdStr + "_" + userDetails.getUsername();
            clientId.remove();
        } else {
            clientId.set(userDetails.getUsername());
            redisKey = redisKey + userDetails.getUsername();
        }
        return redisKey;
    }

    public void passwordErrorLimitCount(String redisKey) {
        Object redisNum = this.redisTemplate.opsForValue().get((Object)redisKey);
        if (redisNum != null) {
            this.redisTemplate.opsForValue().increment((Object)redisKey, 1L);
        } else {
            this.redisTemplate.opsForValue().set((Object)redisKey, (Object)"1", this.sysConfigManager.getOauth2AuthenticationLockTime(), TimeUnit.SECONDS);
        }
    }

    public void passwordLimitCountReset(String redisKey) {
        Object redisNum = this.redisTemplate.opsForValue().get((Object)redisKey);
        if (redisNum != null) {
            this.redisTemplate.delete((Object)redisKey);
        }
    }

    public void isAuthenticationLimit(UserDetails userDetails, String redisKey) {
        Object redisNum = this.redisTemplate.opsForValue().get((Object)redisKey);
        if (redisNum != null && Integer.valueOf(redisNum.toString()) >= this.sysConfigManager.getOauth2AuthenticationNum()) {
            String msg = "";
            msg = userDetails instanceof CustomUserDetails ? "User Authentication is Limited" : "Client Authentication is Limited";
            throw new LockedException(msg);
        }
    }

    public static void clearClientInfo() {
        if (clientId.get() != null) {
            clientId.remove();
        }
    }
}

