/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.script.service.impl;

import com.hand.hap.script.service.IScriptService;
import java.io.Reader;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ScriptServiceImpl
implements IScriptService {
    @Autowired
    private ApplicationContext applicationContext;
    private final Logger logger = LoggerFactory.getLogger(ScriptServiceImpl.class);

    private ScriptEngine initScriptEngine(Map<String, Object> contextParameter) {
        ScriptEngineManager sem = new ScriptEngineManager();
        ScriptEngine engine = sem.getEngineByName("JavaScript");
        engine.put("applicationContext", this.applicationContext);
        engine.put("out", System.out);
        engine.put("logger", this.logger);
        if (contextParameter != null) {
            contextParameter.forEach((k, v) -> engine.put((String)k, v));
        }
        return engine;
    }

    public Object execute(String scriptName, Reader reader, Map<String, Object> contextParameter) throws Exception {
        if (null == reader) {
            throw new Exception("reader is blank");
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] buff = new char[1024];
        int len = -1;
        while ((len = IOUtils.read((Reader)reader, (char[])buff)) != -1 && len != 0) {
            stringBuilder.append(buff, 0, len);
        }
        IOUtils.closeQuietly((Reader)reader);
        Object result = this.execute(scriptName, stringBuilder.toString(), contextParameter);
        return result;
    }

    public Object execute(String scriptName, String script, Map<String, Object> contextParameter) throws Exception {
        if (StringUtils.isBlank((String)script)) {
            throw new Exception("script is blank");
        }
        Object result = null;
        long starTime = System.currentTimeMillis();
        ScriptException scriptException = null;
        try {
            result = this.initScriptEngine(contextParameter).eval(script);
        }
        catch (ScriptException e) {
            scriptException = e;
            throw e;
        }
        finally {
            long endTime = System.currentTimeMillis();
            if (this.logger.isDebugEnabled() && null == scriptException) {
                this.logger.debug("The script {} running time: {} ms", (Object)scriptName, (Object)(endTime - starTime));
            }
        }
        return result;
    }
}

