/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mybatis.mapperhelper;

import com.hand.hap.mybatis.entity.Config;
import com.hand.hap.mybatis.entity.EntityColumn;
import com.hand.hap.mybatis.entity.EntityTable;
import com.hand.hap.mybatis.entity.IDynamicTableName;
import com.hand.hap.mybatis.mapperhelper.EntityHelper;
import com.hand.hap.mybatis.mapperhelper.MapperHelper;
import com.hand.hap.mybatis.mapperhelper.MultipleJdbc3KeyGenerator;
import com.hand.hap.mybatis.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMap;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.scripting.xmltags.ChooseSqlNode;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.ForEachSqlNode;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.scripting.xmltags.WhereSqlNode;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class MapperTemplate {
    private static final XMLLanguageDriver languageDriver = new XMLLanguageDriver();
    private Map<String, Method> methodMap = new HashMap();
    private Map<String, Class<?>> entityClassMap = new HashMap();
    private Class<?> mapperClass;
    private MapperHelper mapperHelper;

    public MapperTemplate() {
    }

    public MapperTemplate(Class<?> mapperClass, MapperHelper mapperHelper) {
        this.mapperClass = mapperClass;
        this.mapperHelper = mapperHelper;
    }

    public static Class<?> getMapperClass(String msId) {
        if (msId.indexOf(46) == -1) {
            throw new RuntimeException("\u5f53\u524dMappedStatement\u7684id=" + msId + ",\u4e0d\u7b26\u5408MappedStatement\u7684\u89c4\u5219!");
        }
        String mapperClassStr = msId.substring(0, msId.lastIndexOf(46));
        try {
            return Class.forName(mapperClassStr);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Map<String, Class<?>> getEntityClassMap() {
        return this.entityClassMap;
    }

    public static String getMethodName(MappedStatement ms) {
        return MapperTemplate.getMethodName((String)ms.getId());
    }

    public static String getMethodName(String msId) {
        return msId.substring(msId.lastIndexOf(".") + 1);
    }

    public String dynamicSQL(Object record) {
        return "dynamicSQL";
    }

    public void addMethodMap(String methodName, Method method) {
        this.methodMap.put(methodName, method);
    }

    public String getUUID() {
        return this.mapperHelper.getConfig().getUUID();
    }

    public String getIDENTITY() {
        return this.mapperHelper.getConfig().getIDENTITY();
    }

    public boolean isBEFORE() {
        return this.mapperHelper.getConfig().isBEFORE();
    }

    public boolean isNotEmpty() {
        return this.mapperHelper.getConfig().isNotEmpty();
    }

    public boolean supportMethod(String msId) {
        Class newMapperClass = MapperTemplate.getMapperClass((String)msId);
        if (newMapperClass != null && this.mapperClass.isAssignableFrom(newMapperClass)) {
            String methodName = MapperTemplate.getMethodName((String)msId);
            return this.methodMap.get(methodName) != null;
        }
        return false;
    }

    protected void setResultType(MappedStatement ms, Class<?> entityClass) {
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        resultMaps.add(entityTable.getResultMap(ms.getConfiguration()));
        MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
        metaObject.setValue("resultMaps", Collections.unmodifiableList(resultMaps));
    }

    protected void setSqlSource(MappedStatement ms, SqlSource sqlSource) {
        MetaObject msObject = SystemMetaObject.forObject((Object)ms);
        msObject.setValue("sqlSource", (Object)sqlSource);
        KeyGenerator keyGenerator = ms.getKeyGenerator();
        if (keyGenerator instanceof Jdbc3KeyGenerator) {
            msObject.setValue("keyGenerator", (Object)new MultipleJdbc3KeyGenerator());
        }
    }

    private void checkCache(MappedStatement ms) throws Exception {
        if (ms.getCache() == null) {
            Cache cache;
            String nameSpace = ms.getId().substring(0, ms.getId().lastIndexOf(46));
            try {
                cache = ms.getConfiguration().getCache(nameSpace);
            }
            catch (IllegalArgumentException e) {
                return;
            }
            if (cache != null) {
                MetaObject metaObject = SystemMetaObject.forObject((Object)ms);
                metaObject.setValue("cache", (Object)cache);
            }
        }
    }

    public void setSqlSource(MappedStatement ms) throws Exception {
        if (this.mapperClass == MapperTemplate.getMapperClass((String)ms.getId())) {
            throw new RuntimeException("\u8bf7\u4e0d\u8981\u914d\u7f6e\u6216\u626b\u63cf\u901a\u7528Mapper\u63a5\u53e3\u7c7b\uff1a" + this.mapperClass);
        }
        Method method = (Method)this.methodMap.get(MapperTemplate.getMethodName((MappedStatement)ms));
        try {
            if (method.getReturnType() == Void.TYPE) {
                method.invoke((Object)this, ms);
            } else if (SqlNode.class.isAssignableFrom(method.getReturnType())) {
                SqlNode sqlNode = (SqlNode)method.invoke((Object)this, ms);
                DynamicSqlSource dynamicSqlSource = new DynamicSqlSource(ms.getConfiguration(), sqlNode);
                this.setSqlSource(ms, (SqlSource)dynamicSqlSource);
            } else if (String.class.equals(method.getReturnType())) {
                String xmlSql = (String)method.invoke((Object)this, ms);
                SqlSource sqlSource = this.createSqlSource(ms, xmlSql);
                this.setSqlSource(ms, sqlSource);
            } else {
                throw new RuntimeException("\u81ea\u5b9a\u4e49Mapper\u65b9\u6cd5\u8fd4\u56de\u7c7b\u578b\u9519\u8bef,\u53ef\u9009\u7684\u8fd4\u56de\u7c7b\u578b\u4e3avoid,SqlNode,String\u4e09\u79cd!");
            }
            this.checkCache(ms);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException() != null ? e.getTargetException() : e);
        }
    }

    public SqlSource createSqlSource(MappedStatement ms, String xmlSql) {
        return languageDriver.createSqlSource(ms.getConfiguration(), "<script>\n\t" + xmlSql + "</script>", null);
    }

    public Class<?> getEntityClass(MappedStatement ms) {
        String msId = ms.getId();
        if (this.entityClassMap.containsKey(msId)) {
            return (Class)this.entityClassMap.get(msId);
        }
        Class mapperClass = MapperTemplate.getMapperClass((String)msId);
        Type[] types = mapperClass.getGenericInterfaces();
        if (null != types) {
            for (Type type : types) {
                ParameterizedType t;
                if (!(type instanceof ParameterizedType) || (t = (ParameterizedType)type).getRawType() != this.mapperClass && !this.mapperClass.isAssignableFrom((Class)t.getRawType())) continue;
                Class returnType = (Class)t.getActualTypeArguments()[0];
                EntityHelper.initEntityNameMap((Class)returnType, (Config)this.mapperHelper.getConfig());
                this.entityClassMap.put(msId, returnType);
                return returnType;
            }
        }
        throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6Mapper<T>\u6cdb\u578b\u7c7b\u578b:" + msId);
    }

    @Deprecated
    protected List<ParameterMapping> getPrimaryKeyParameterMappings(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        Set entityColumns = EntityHelper.getPKColumns((Class)entityClass);
        ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        for (EntityColumn column : entityColumns) {
            ParameterMapping.Builder builder = new ParameterMapping.Builder(ms.getConfiguration(), column.getProperty(), column.getJavaType());
            builder.mode(ParameterMode.IN);
            parameterMappings.add(builder.build());
        }
        return parameterMappings;
    }

    protected String getSeqNextVal(EntityColumn column) {
        if (StringUtil.isNotEmpty((String)column.getSequenceName())) {
            return column.getSequenceName() + ".nextval";
        }
        return MessageFormat.format(this.mapperHelper.getConfig().getSeqFormat(), column.getSequenceName(), column.getColumn(), column.getProperty(), column.getTable().getName());
    }

    protected String tableName(Class<?> entityClass) {
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        String prefix = entityTable.getPrefix();
        if (StringUtil.isEmpty((String)prefix)) {
            prefix = this.mapperHelper.getConfig().getPrefix();
        }
        if (StringUtil.isNotEmpty((String)prefix)) {
            return prefix + "." + entityTable.getName();
        }
        return entityTable.getName();
    }

    @Deprecated
    protected SqlNode getDynamicTableNameNode(Class<?> entityClass) {
        if (IDynamicTableName.class.isAssignableFrom(entityClass)) {
            ArrayList<IfSqlNode> ifSqlNodes = new ArrayList<IfSqlNode>();
            ifSqlNodes.add(new IfSqlNode((SqlNode)new TextSqlNode("${dynamicTableName}"), "@com.hand.hap.mybatis.util.OGNL@isDynamicParameter(_parameter) and dynamicTableName != null and dynamicTableName != ''"));
            ifSqlNodes.add(new IfSqlNode((SqlNode)new StaticTextSqlNode(this.tableName(entityClass)), "@com.hand.hap.mybatis.util.OGNL@isNotDynamicParameter(_parameter) or dynamicTableName == null or dynamicTableName == ''"));
            return new MixedSqlNode(ifSqlNodes);
        }
        return new StaticTextSqlNode(this.tableName(entityClass));
    }

    @Deprecated
    protected SqlNode getDynamicTableNameNode(Class<?> entityClass, String parameterName) {
        if (IDynamicTableName.class.isAssignableFrom(entityClass)) {
            ArrayList<IfSqlNode> ifSqlNodes = new ArrayList<IfSqlNode>();
            ifSqlNodes.add(new IfSqlNode((SqlNode)new TextSqlNode("${" + parameterName + ".dynamicTableName}"), "@com.hand.hap.mybatis.util.OGNL@isDynamicParameter(" + parameterName + ") and " + parameterName + ".dynamicTableName != null and  " + parameterName + ".dynamicTableName != ''"));
            ifSqlNodes.add(new IfSqlNode((SqlNode)new StaticTextSqlNode(this.tableName(entityClass)), "@com.hand.hap.mybatis.util.OGNL@isNotDynamicParameter(" + parameterName + ") or " + parameterName + ".dynamicTableName == null or " + parameterName + ".dynamicTableName == ''"));
            return new MixedSqlNode(ifSqlNodes);
        }
        return new StaticTextSqlNode(this.tableName(entityClass));
    }

    @Deprecated
    protected SqlNode getIfNotNull(EntityColumn column, SqlNode columnNode) {
        return this.getIfNotNull(column, columnNode, false);
    }

    @Deprecated
    protected SqlNode getIfNotNull(EntityColumn column, SqlNode columnNode, boolean empty) {
        if (empty && column.getJavaType().equals(String.class)) {
            return new IfSqlNode(columnNode, column.getProperty() + " != null and " + column.getProperty() + " != ''");
        }
        return new IfSqlNode(columnNode, column.getProperty() + " != null ");
    }

    @Deprecated
    protected SqlNode getIfIsNull(EntityColumn column, SqlNode columnNode) {
        return new IfSqlNode(columnNode, column.getProperty() + " == null ");
    }

    @Deprecated
    protected SqlNode getIfCacheNotNull(EntityColumn column, SqlNode columnNode) {
        return new IfSqlNode(columnNode, column.getProperty() + "_cache != null ");
    }

    @Deprecated
    protected SqlNode getIfCacheIsNull(EntityColumn column, SqlNode columnNode) {
        return new IfSqlNode(columnNode, column.getProperty() + "_cache == null ");
    }

    @Deprecated
    protected SqlNode getColumnEqualsProperty(EntityColumn column, boolean first) {
        return new StaticTextSqlNode((first ? "" : " AND ") + column.getColumnEqualsHolder());
    }

    @Deprecated
    protected SqlNode getAllIfColumnNode(Class<?> entityClass) {
        Set columnList = EntityHelper.getColumns(entityClass);
        ArrayList<SqlNode> ifNodes = new ArrayList<SqlNode>();
        boolean first = true;
        for (EntityColumn column : columnList) {
            ifNodes.add(this.getIfNotNull(column, this.getColumnEqualsProperty(column, first), this.isNotEmpty()));
            first = false;
        }
        return new MixedSqlNode(ifNodes);
    }

    @Deprecated
    protected List<ParameterMapping> getColumnParameterMappings(MappedStatement ms) {
        Class entityClass = this.getEntityClass(ms);
        Set entityColumns = EntityHelper.getColumns((Class)entityClass);
        ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
        for (EntityColumn column : entityColumns) {
            ParameterMapping.Builder builder = new ParameterMapping.Builder(ms.getConfiguration(), column.getProperty(), column.getJavaType());
            builder.mode(ParameterMode.IN);
            parameterMappings.add(builder.build());
        }
        return parameterMappings;
    }

    protected void newSelectKeyMappedStatement(MappedStatement ms, EntityColumn column) {
        Jdbc3KeyGenerator keyGenerator;
        String IDENTITY;
        String keyId = ms.getId() + "!selectKey";
        if (ms.getConfiguration().hasKeyGenerator(keyId)) {
            return;
        }
        Class entityClass = this.getEntityClass(ms);
        Configuration configuration = ms.getConfiguration();
        Boolean executeBefore = this.isBEFORE();
        String generator = column.getGenerator() == null ? null : column.getGenerator();
        String string = IDENTITY = "IDENTITY".equals(generator) || StringUtil.isEmpty((String)generator) ? this.getIDENTITY() : generator;
        if ("JDBC".equalsIgnoreCase(IDENTITY)) {
            keyGenerator = new Jdbc3KeyGenerator();
        } else {
            if ("SEQUENCE".equalsIgnoreCase(IDENTITY)) {
                String DBType = Optional.ofNullable(this.mapperHelper.getConfig().getDataBaseType()).orElse("oracle");
                switch (DBType.toLowerCase()) {
                    case "hana": {
                        IDENTITY = "SELECT " + this.getSeqNextVal(column) + " FROM DUMMY";
                        break;
                    }
                    case "postgresql": {
                        IDENTITY = "SELECT nextval('" + column.getTable().getName() + "_s')";
                        break;
                    }
                    default: {
                        IDENTITY = "SELECT " + this.getSeqNextVal(column) + " FROM DUAL";
                    }
                }
            }
            RawSqlSource sqlSource = new RawSqlSource(configuration, IDENTITY, entityClass);
            MappedStatement.Builder statementBuilder = new MappedStatement.Builder(configuration, keyId, (SqlSource)sqlSource, SqlCommandType.SELECT);
            statementBuilder.resource(ms.getResource());
            statementBuilder.fetchSize(null);
            statementBuilder.statementType(StatementType.STATEMENT);
            statementBuilder.keyGenerator((KeyGenerator)new NoKeyGenerator());
            statementBuilder.keyProperty(column.getProperty());
            statementBuilder.keyColumn(null);
            statementBuilder.databaseId(null);
            statementBuilder.lang(configuration.getDefaultScriptingLanuageInstance());
            statementBuilder.resultOrdered(false);
            statementBuilder.resulSets(null);
            statementBuilder.timeout(configuration.getDefaultStatementTimeout());
            ArrayList parameterMappings = new ArrayList();
            ParameterMap.Builder inlineParameterMapBuilder = new ParameterMap.Builder(configuration, statementBuilder.id() + "-Inline", entityClass, parameterMappings);
            statementBuilder.parameterMap(inlineParameterMapBuilder.build());
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            ResultMap.Builder inlineResultMapBuilder = new ResultMap.Builder(configuration, statementBuilder.id() + "-Inline", column.getJavaType(), new ArrayList(), null);
            resultMaps.add(inlineResultMapBuilder.build());
            statementBuilder.resultMaps(resultMaps);
            statementBuilder.resultSetType(null);
            statementBuilder.flushCacheRequired(false);
            statementBuilder.useCache(false);
            statementBuilder.cache(null);
            MappedStatement statement = statementBuilder.build();
            try {
                configuration.addMappedStatement(statement);
            }
            catch (Exception exception) {
                // empty catch block
            }
            MappedStatement keyStatement = configuration.getMappedStatement(keyId, false);
            keyGenerator = new SelectKeyGenerator(keyStatement, executeBefore.booleanValue());
            try {
                configuration.addKeyGenerator(keyId, (KeyGenerator)keyGenerator);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            MetaObject msObject = SystemMetaObject.forObject((Object)ms);
            msObject.setValue("keyGenerator", (Object)keyGenerator);
            msObject.setValue("keyProperties", (Object)column.getTable().getKeyProperties());
            msObject.setValue("keyColumns", (Object)column.getTable().getKeyColumns());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deprecated
    public IfSqlNode ExampleValidSqlNode(Configuration configuration) {
        ArrayList<IfSqlNode> whenSqlNodes = new ArrayList<IfSqlNode>();
        IfSqlNode noValueSqlNode = new IfSqlNode((SqlNode)new TextSqlNode(" and ${criterion.condition}"), "criterion.noValue");
        whenSqlNodes.add(noValueSqlNode);
        IfSqlNode singleValueSqlNode = new IfSqlNode((SqlNode)new TextSqlNode(" and ${criterion.condition} #{criterion.value}"), "criterion.singleValue");
        whenSqlNodes.add(singleValueSqlNode);
        IfSqlNode betweenValueSqlNode = new IfSqlNode((SqlNode)new TextSqlNode(" and ${criterion.condition} #{criterion.value} and #{criterion.secondValue}"), "criterion.betweenValue");
        whenSqlNodes.add(betweenValueSqlNode);
        ArrayList<Object> listValueContentSqlNodes = new ArrayList<Object>();
        listValueContentSqlNodes.add(new TextSqlNode(" and ${criterion.condition}"));
        ForEachSqlNode listValueForEachSqlNode = new ForEachSqlNode(configuration, (SqlNode)new StaticTextSqlNode("#{listItem}"), "criterion.value", null, "listItem", "(", ")", ",");
        listValueContentSqlNodes.add(listValueForEachSqlNode);
        IfSqlNode listValueSqlNode = new IfSqlNode((SqlNode)new MixedSqlNode(listValueContentSqlNodes), "criterion.listValue");
        whenSqlNodes.add(listValueSqlNode);
        ChooseSqlNode chooseSqlNode = new ChooseSqlNode(whenSqlNodes, null);
        ForEachSqlNode criteriaSqlNode = new ForEachSqlNode(configuration, (SqlNode)chooseSqlNode, "criteria.criteria", null, "criterion", null, null, null);
        TrimSqlNode trimSqlNode = new TrimSqlNode(configuration, (SqlNode)criteriaSqlNode, "(", "and", ")", null);
        IfSqlNode validSqlNode = new IfSqlNode((SqlNode)trimSqlNode, "criteria.valid");
        return validSqlNode;
    }

    @Deprecated
    public WhereSqlNode exampleWhereClause(Configuration configuration) {
        ForEachSqlNode forEachSqlNode = new ForEachSqlNode(configuration, (SqlNode)this.ExampleValidSqlNode(configuration), "oredCriteria", null, "criteria", null, null, " or ");
        WhereSqlNode whereSqlNode = new WhereSqlNode(configuration, (SqlNode)forEachSqlNode);
        return whereSqlNode;
    }

    @Deprecated
    public WhereSqlNode updateByExampleWhereClause(Configuration configuration) {
        ForEachSqlNode forEachSqlNode = new ForEachSqlNode(configuration, (SqlNode)this.ExampleValidSqlNode(configuration), "example.oredCriteria", null, "criteria", null, null, " or ");
        WhereSqlNode whereSqlNode = new WhereSqlNode(configuration, (SqlNode)forEachSqlNode);
        return whereSqlNode;
    }
}

