/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.impl;

import com.hand.hap.message.IMessageConsumer;
import java.lang.reflect.Method;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ReflectionUtils;

public class MessageConsumerAdaptor<T>
implements IMessageConsumer<T>,
InitializingBean {
    private Object delegate;
    private String methodName;
    private Method method;

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void onMessage(T message, String pattern) {
        try {
            this.method.invoke(this.delegate, message, pattern);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke target method '" + this.methodName + "' with argument: " + message);
        }
    }

    public void afterPropertiesSet() throws Exception {
        ReflectionUtils.doWithMethods(this.delegate.getClass(), method -> {
            ReflectionUtils.makeAccessible((Method)method);
            this.method = method;
        }, method -> {
            if (method.getName().equals(this.getMethodName())) {
                Class<?>[] paraTypes = method.getParameterTypes();
                return paraTypes.length == 2 && paraTypes[1] == String.class;
            }
            return false;
        });
        if (this.method == null) {
            throw new RuntimeException("No suitable method named '" + this.methodName + "' found in " + this.delegate);
        }
    }
}

