/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.message.components;

import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.TopicMonitor;
import com.hand.hap.task.dto.TaskExecution;
import com.hand.hap.task.info.ThreadManageInfo;
import com.hand.hap.task.service.ITaskExecutionService;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@TopicMonitor(channel={"task_cancel"})
public class TaskCancel
implements IMessageConsumer<TaskExecution>,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(TaskCancel.class);
    public static final String TASK_CANCEL = "task_cancel";
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    @Autowired
    private ITaskExecutionService taskExecutionService;

    public void onMessage(TaskExecution message, String pattern) {
        String string;
        Thread thread;
        boolean isReady = false;
        String readyKey = "TASKQUEUE-" + message.getExecutionId();
        BlockingQueue<Runnable> taskQueue = this.taskExecutor.getThreadPoolExecutor().getQueue();
        for (Thread thread2 : taskQueue) {
            if (!thread2.getName().equals(readyKey)) continue;
            taskQueue.remove(thread2);
            this.taskExecutionService.updateStatus(message.getExecutionId(), "CANCEL");
            this.taskExecutionService.batchUpdateStatus(message.getExecutionId(), "READY", "UNEXECUTED");
            isReady = true;
            return;
        }
        if (!isReady && (thread = (Thread)ThreadManageInfo.threadHashMap.get(string = "TASK-" + message.getExecutionId())) != null) {
            logger.info("TaskThread {} interrupt", (Object)string);
            thread.interrupt();
            this.taskExecutionService.updateStatus(message.getExecutionId(), "CANCELING");
            this.taskExecutionService.batchUpdateStatus(message.getExecutionId(), "EXECUTING", "CANCELING");
            ThreadManageInfo.threadHashMap.remove(string);
        }
    }

    public void afterPropertiesSet() throws Exception {
    }
}

