/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.cache.impl.MessageEmailConfigCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.EmailException;
import com.hand.hap.mail.dto.MessageEmailAccount;
import com.hand.hap.mail.dto.MessageEmailConfig;
import com.hand.hap.mail.dto.MessageEmailProperty;
import com.hand.hap.mail.dto.MessageEmailWhiteList;
import com.hand.hap.mail.mapper.MessageEmailAccountMapper;
import com.hand.hap.mail.mapper.MessageEmailConfigMapper;
import com.hand.hap.mail.mapper.MessageEmailPropertyMapper;
import com.hand.hap.mail.mapper.MessageEmailWhiteListMapper;
import com.hand.hap.mail.service.IMessageEmailConfigService;
import com.hand.hap.security.service.IAESClientService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessageEmailConfigServiceImpl
extends BaseServiceImpl<MessageEmailConfig>
implements IMessageEmailConfigService,
BeanFactoryAware {
    public static final String MSG_MESSAGE_NO_WHITE_LIST = "msg.warning.system.email_message_no_whitelist";
    public static final String MSG_MESSAGE_NO_ACCOUNT_LIST = "msg.warning.system.email_message_on_accountlist";
    private BeanFactory beanFactory;
    @Autowired
    private MessageEmailConfigMapper mapper;
    @Autowired
    private MessageEmailAccountMapper accountMapper;
    @Autowired
    private MessageEmailWhiteListMapper addressMapper;
    @Autowired
    private MessageEmailPropertyMapper messageEmailPropertyMapper;
    @Autowired
    private IAESClientService aceClientService;
    @Autowired
    private MessageEmailConfigCache configCache;

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Transactional(rollbackFor={Exception.class})
    public MessageEmailConfig createMessageEmailConfig(IRequest request, MessageEmailConfig obj) {
        if (obj == null) {
            return null;
        }
        obj.setPassword(this.aceClientService.encrypt(obj.getPassword()));
        this.mapper.insertSelective((Object)obj);
        return obj;
    }

    @Transactional(rollbackFor={Exception.class})
    public MessageEmailConfig updateMessageEmailConfig(IRequest request, MessageEmailConfig obj) {
        if (obj == null) {
            return null;
        }
        MessageEmailConfig config = (MessageEmailConfig)this.mapper.selectByPrimaryKey((Object)obj.getConfigId());
        if (config != null) {
            if (config.getPassword() != null && config.getPassword().equals(obj.getPassword())) {
                obj.setPassword(null);
            } else {
                obj.setPassword(this.aceClientService.encrypt(obj.getPassword()));
            }
        }
        int updateCount = this.mapper.updateByPrimaryKeySelective((Object)obj);
        this.checkOvn(updateCount, (Object)obj);
        return obj;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public MessageEmailConfig selectMessageEmailConfigById(IRequest request, Long objId) {
        if (objId == null) {
            return null;
        }
        return (MessageEmailConfig)this.mapper.selectByPrimaryKey((Object)objId);
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteMessageEmailConfig(IRequest request, MessageEmailConfig obj) {
        if (obj.getConfigId() == null) {
            return 0;
        }
        this.accountMapper.deleteByConfigId(obj.getConfigId());
        this.addressMapper.deleteByConfigId(obj.getConfigId());
        this.messageEmailPropertyMapper.deleteByConfigId(obj.getConfigId().longValue());
        int updateCount = this.mapper.deleteByPrimaryKey((Object)obj);
        this.checkOvn(updateCount, (Object)obj);
        this.configCache.remove(obj.getConfigId());
        return updateCount;
    }

    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(IRequest request, List<MessageEmailConfig> objs) {
        int result = 0;
        if (CollectionUtils.isEmpty(objs)) {
            return result;
        }
        for (MessageEmailConfig obj : objs) {
            ((IMessageEmailConfigService)this.self()).deleteMessageEmailConfig(request, obj);
            ++result;
        }
        return result;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<MessageEmailConfig> selectMessageEmailConfigs(IRequest request, MessageEmailConfig example, int page, int pageSize) {
        PageHelper.startPage((int)page, (int)pageSize);
        return this.mapper.selectMessageEmailConfigs(example);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchUpdate(IRequest requestContext, MessageEmailConfig obj) throws EmailException {
        if (obj != null) {
            if (CollectionUtils.isEmpty((Collection)obj.getEmailAccounts())) {
                throw new EmailException(MSG_MESSAGE_NO_ACCOUNT_LIST);
            }
            if ("Y".equalsIgnoreCase(obj.getUseWhiteList()) && CollectionUtils.isEmpty((Collection)obj.getWhiteLists())) {
                throw new EmailException(MSG_MESSAGE_NO_WHITE_LIST);
            }
            if (obj.getConfigId() == null) {
                this.createMessageEmailConfig(requestContext, obj);
            } else {
                this.updateMessageEmailConfig(requestContext, obj);
            }
            if (obj.getEmailAccounts() != null) {
                for (MessageEmailAccount current : obj.getEmailAccounts()) {
                    if (current.getAccountId() == null) {
                        current.setObjectVersionNumber(Long.valueOf(0L));
                        current.setConfigId(obj.getConfigId());
                        this.createEmailAccount(requestContext, current);
                        continue;
                    }
                    this.updateEmailAccount(requestContext, current);
                }
            }
            if (obj.getWhiteLists() != null) {
                for (MessageEmailAccount current : obj.getWhiteLists()) {
                    if (current.getId() == null) {
                        current.setObjectVersionNumber(Long.valueOf(0L));
                        current.setConfigId(obj.getConfigId());
                        this.createAddress(requestContext, (MessageEmailWhiteList)current);
                        continue;
                    }
                    this.updateAddress(requestContext, (MessageEmailWhiteList)current);
                }
            }
            if (obj.getPropertyLists() != null) {
                for (MessageEmailAccount current : obj.getPropertyLists()) {
                    if (current.getPropertyId() == null) {
                        current.setObjectVersionNumber(Long.valueOf(0L));
                        current.setConfigId(obj.getConfigId());
                        this.createProperty(requestContext, (MessageEmailProperty)current);
                        continue;
                    }
                    this.updateProperty(requestContext, (MessageEmailProperty)current);
                }
            }
        }
        this.configCache.reload(obj.getConfigId());
    }

    private MessageEmailAccount createEmailAccount(IRequest request, MessageEmailAccount obj) {
        if (obj == null) {
            return null;
        }
        this.accountMapper.insertSelective((Object)obj);
        return obj;
    }

    private MessageEmailWhiteList createAddress(IRequest request, MessageEmailWhiteList obj) {
        if (obj == null) {
            return null;
        }
        this.addressMapper.insertSelective((Object)obj);
        return obj;
    }

    private MessageEmailAccount updateEmailAccount(IRequest request, MessageEmailAccount obj) {
        if (obj == null) {
            return null;
        }
        int updateCount = this.accountMapper.updateByPrimaryKeySelective((Object)obj);
        this.checkOvn(updateCount, (Object)obj);
        return obj;
    }

    private MessageEmailWhiteList updateAddress(IRequest request, MessageEmailWhiteList obj) {
        if (obj == null) {
            return null;
        }
        int updateCount = this.addressMapper.updateByPrimaryKeySelective((Object)obj);
        this.checkOvn(updateCount, (Object)obj);
        return obj;
    }

    private MessageEmailProperty createProperty(IRequest request, MessageEmailProperty obj) {
        if (obj == null) {
            return null;
        }
        this.messageEmailPropertyMapper.insertSelective((Object)obj);
        return obj;
    }

    private MessageEmailProperty updateProperty(IRequest request, MessageEmailProperty obj) {
        if (obj == null) {
            return null;
        }
        int updateCount = this.messageEmailPropertyMapper.updateByPrimaryKeySelective((Object)obj);
        this.checkOvn(updateCount, (Object)obj);
        return obj;
    }
}

