/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.attachment.dto.SysFile;
import com.hand.hap.attachment.service.ISysFileService;
import com.hand.hap.cache.impl.MessageEmailConfigCache;
import com.hand.hap.mail.EmailStatusEnum;
import com.hand.hap.mail.EnvironmentEnum;
import com.hand.hap.mail.MailSender;
import com.hand.hap.mail.ReceiverTypeEnum;
import com.hand.hap.mail.dto.Message;
import com.hand.hap.mail.dto.MessageAddress;
import com.hand.hap.mail.dto.MessageAttachment;
import com.hand.hap.mail.dto.MessageEmailAccount;
import com.hand.hap.mail.dto.MessageEmailConfig;
import com.hand.hap.mail.dto.MessageEmailProperty;
import com.hand.hap.mail.dto.MessageEmailWhiteList;
import com.hand.hap.mail.dto.MessageReceiver;
import com.hand.hap.mail.dto.MessageTransaction;
import com.hand.hap.mail.mapper.MessageAttachmentMapper;
import com.hand.hap.mail.mapper.MessageEmailAccountMapper;
import com.hand.hap.mail.mapper.MessageEmailConfigMapper;
import com.hand.hap.mail.mapper.MessageEmailPropertyMapper;
import com.hand.hap.mail.mapper.MessageEmailWhiteListMapper;
import com.hand.hap.mail.mapper.MessageMapper;
import com.hand.hap.mail.mapper.MessageReceiverMapper;
import com.hand.hap.mail.mapper.MessageTransactionMapper;
import com.hand.hap.mail.service.IEmailService;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service
public class EmailServiceImpl
implements IEmailService,
BeanFactoryAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int TWENTY = 20;
    private static final int FIFTY = 50;
    private static final String ATTACHMENT_FILE = "file";
    private static final String ATTACHMENT_SYSTEM = "system";
    @Autowired
    private MessageMapper messageMapper;
    @Autowired
    private MessageAttachmentMapper attachmentMapper;
    @Autowired
    private MessageReceiverMapper receiverMapper;
    @Autowired
    private MessageTransactionMapper transactionMapper;
    @Autowired
    private MessageEmailAccountMapper emailAccountMapper;
    @Autowired
    private MessageEmailWhiteListMapper emailWhiteListMapper;
    @Autowired
    private MessageEmailConfigMapper emailConfigMapper;
    private BeanFactory beanFactory;
    @Autowired
    private ISysFileService sysFileService;
    @Autowired
    private MessageEmailPropertyMapper emailPropertyMapper;
    @Autowired
    private MessageEmailConfigCache configCache;

    public boolean sendMessages(Map<String, Object> params) throws Exception {
        Integer batch = (Integer)params.get("batch");
        boolean isVipQueue = (Boolean)params.get("isVipQueue");
        if (batch == null) {
            batch = 20;
        }
        if (batch == 0) {
            batch = 20;
        }
        PageHelper.startPage((int)1, (int)batch);
        List userEmailToSend = isVipQueue ? this.messageMapper.selectVipEmailToSend() : this.messageMapper.selectEmailToSend();
        return this.sendMessage(userEmailToSend, params);
    }

    public boolean reSendMessages(List<Message> messages, Map<String, Object> params) throws Exception {
        return this.sendMessage(messages, params);
    }

    public boolean sendMessageByReceiver(Message message, Map<String, Object> params) throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(message);
        return this.sendMessage(messages, params);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public boolean sendEmailMessage(List<Message> userEmailToSend, Map<String, Object> params) throws Exception {
        this.sendEmail(userEmailToSend, null, params, ATTACHMENT_SYSTEM);
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public boolean sendEmailMessageWithFile(List<Message> userEmailToSend, List<File> fileList) throws Exception {
        this.sendEmail(userEmailToSend, fileList, null, ATTACHMENT_FILE);
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public boolean sendSingleEmailMessage(Message currentMessage, Map<String, Object> params) throws Exception {
        return this.sendSingleEmail(currentMessage, params, null, ATTACHMENT_SYSTEM);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public boolean sendSingleEmailMessageWithFile(Message message, List<File> fileList) throws Exception {
        return this.sendSingleEmail(message, null, fileList, ATTACHMENT_FILE);
    }

    public boolean sendMessage(List<Message> userEmailToSend, Map<String, Object> params) throws Exception {
        HashMap<String, MailSender> senders = new HashMap<String, MailSender>(1);
        int success = 0;
        this.messageSetPending(userEmailToSend);
        try {
            block4: for (Message currentMessage : userEmailToSend) {
                MimeMessage mimeMessage;
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{currentMessage.getSubject(), currentMessage.getContent()})) {
                    this.error(currentMessage, "subject or content is null");
                    continue;
                }
                List attachments = this.attachmentMapper.selectByMessageId(currentMessage.getMessageId());
                String messageFrom = currentMessage.getMessageFrom();
                MessageAddress address = MessageAddress.toAddressObject((String)messageFrom);
                MailSender mailSender = (MailSender)senders.get(messageFrom = address.getAddress());
                if (mailSender == null) {
                    mailSender = (MailSender)this.beanFactory.getBean("mailSender");
                    MessageEmailAccount record = new MessageEmailAccount();
                    record.setAccountCode(messageFrom);
                    List selectMessageEmailAccounts = this.emailAccountMapper.selectMessageEmailAccounts(record);
                    if (CollectionUtils.isEmpty((Collection)selectMessageEmailAccounts)) {
                        this.error(currentMessage, "email account is no more exists:" + messageFrom);
                        continue;
                    }
                    MessageEmailAccount mailAccount = (MessageEmailAccount)selectMessageEmailAccounts.get(0);
                    if (mailAccount == null) {
                        this.error(currentMessage, "email account is no more exists:" + messageFrom);
                        continue;
                    }
                    MessageEmailConfig config = (MessageEmailConfig)this.emailConfigMapper.selectByPrimaryKey((Object)mailAccount.getConfigId());
                    mailSender.setHost(config.getHost());
                    mailSender.setPort(Integer.parseInt(config.getPort()));
                    if (config.getTryTimes() != null) {
                        mailSender.setTryTimes(Integer.valueOf(config.getTryTimes().intValue()));
                    }
                    mailSender.setMessageAccount(mailAccount.getUserName());
                    this.setAuthUserNameAndPassword(mailSender, mailAccount, config);
                    if ("Y".equalsIgnoreCase(config.getUseWhiteList())) {
                        List whitelist = this.emailWhiteListMapper.selectByConfigId(config.getConfigId());
                        ArrayList<String> stringList = new ArrayList<String>();
                        for (MessageEmailWhiteList current : whitelist) {
                            stringList.add(current.getAddress());
                        }
                        mailSender.setWhiteList(stringList);
                    }
                    senders.put(messageFrom, mailSender);
                }
                if (ArrayUtils.isEmpty((Object[])(mimeMessage = this.generateMimeMessage(currentMessage, null, attachments, mailSender)).getAllRecipients())) {
                    this.error(currentMessage, "The recipient is empty!");
                    continue;
                }
                MessageTransaction obj = this.generateMessageTransaction(currentMessage);
                for (int i = 0; i < mailSender.getTryTimes(); ++i) {
                    try {
                        mailSender.send(mimeMessage);
                        ++success;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Send mail success, {}.", (Object)i);
                        }
                        obj.setTransactionStatus(EmailStatusEnum.SUCCESS.getCode());
                        currentMessage.setSendFlag("Y");
                        this.trySaveTransaction(currentMessage, obj);
                        continue block4;
                    }
                    catch (Exception e) {
                        if (i == mailSender.getTryTimes() - 1) {
                            this.saveFailMessageTransaction(currentMessage, obj, e);
                            continue;
                        }
                        Thread.sleep(50L);
                        continue;
                    }
                }
            }
        }
        catch (Exception e) {
            params.put("ERROR_MESSAGE", e.getMessage());
            for (Message message : userEmailToSend) {
                this.error(message, e.getMessage());
            }
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        this.prepareSummary(userEmailToSend, params, success);
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW, noRollbackFor={Exception.class})
    public void saveTransaction(Message message, MessageTransaction obj) {
        if (message != null) {
            this.messageMapper.updateByPrimaryKeySelective((Object)message);
        }
        if (obj != null) {
            this.transactionMapper.insertSelective((Object)obj);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private void error(Message message, String msg) {
        MessageTransaction obj = this.generateMessageTransaction(message);
        obj.setTransactionStatus(EmailStatusEnum.ERROR.getCode());
        obj.setTransactionMessage(msg);
        message.setSendFlag("F");
        this.trySaveTransaction(message, obj);
    }

    private void messageSetPending(List<Message> messages) {
        for (Message current : messages) {
            current.setSendFlag("P");
            this.trySaveTransaction(current, null);
        }
    }

    private void setAuthUserNameAndPassword(MailSender mailSender, MessageEmailAccount messageEmailAccount, MessageEmailConfig config) {
        if (StringUtils.isEmpty((CharSequence)messageEmailAccount.getPassword())) {
            mailSender.setUsername(config.getUserName());
            mailSender.setPassword(config.getPassword());
        } else {
            mailSender.setUsername(messageEmailAccount.getUserName());
            mailSender.setPassword(messageEmailAccount.getPassword());
        }
    }

    private boolean sendSingleEmail(Message message, Map<String, Object> params, List<File> fileList, String type) throws MessagingException, UnsupportedEncodingException {
        MimeMessage mimeMessage;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{message.getSubject(), message.getContent()})) {
            this.error(message, "subject or content is null");
            return false;
        }
        MailSender mailSender = this.generateMailSender(message);
        try {
            mimeMessage = this.generateMimeMessage(message, fileList, this.getMessageAttachments(message, type), mailSender);
            if (ArrayUtils.isEmpty((Object[])mimeMessage.getAllRecipients())) {
                this.error(message, "The recipient is empty!");
                return false;
            }
        }
        catch (Exception e) {
            if (params != null) {
                params.put("ERROR_MESSAGE", e.getMessage());
            }
            this.error(message, e.getMessage());
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        MessageTransaction obj = this.generateMessageTransaction(message);
        try {
            mailSender.send(mimeMessage);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Send mail success.");
            }
            obj.setTransactionStatus(EmailStatusEnum.SUCCESS.getCode());
            message.setSendFlag("Y");
            this.trySaveTransaction(message, obj);
        }
        catch (Exception e) {
            this.saveFailMessageTransaction(message, obj, e);
            throw e;
        }
        if (params != null) {
            ArrayList<Message> messageList = new ArrayList<Message>();
            messageList.add(message);
            this.prepareSummary(messageList, params, 1);
        }
        return true;
    }

    private void sendEmail(List<Message> userEmailToSend, List<File> fileList, Map<String, Object> params, String type) throws MessagingException, UnsupportedEncodingException {
        int success = 0;
        HashMap<String, MailSender> senders = new HashMap<String, MailSender>(1);
        try {
            for (Message currentMessage : userEmailToSend) {
                MimeMessage mimeMessage;
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{currentMessage.getSubject(), currentMessage.getContent()})) {
                    this.error(currentMessage, "subject or content is null");
                    continue;
                }
                String messageFrom = currentMessage.getMessageFrom();
                MessageAddress address = MessageAddress.toAddressObject((String)messageFrom);
                MailSender mailSender = (MailSender)senders.get(messageFrom = address.getAddress());
                if (mailSender == null) {
                    mailSender = this.generateMailSender(currentMessage);
                    senders.put(messageFrom, mailSender);
                }
                if (ArrayUtils.isEmpty((Object[])(mimeMessage = this.generateMimeMessage(currentMessage, fileList, this.getMessageAttachments(currentMessage, type), mailSender)).getAllRecipients())) {
                    this.error(currentMessage, "The recipient is empty!");
                    continue;
                }
                MessageTransaction obj = this.generateMessageTransaction(currentMessage);
                try {
                    mailSender.send(mimeMessage);
                    ++success;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Send mail success.");
                    }
                    obj.setTransactionStatus(EmailStatusEnum.SUCCESS.getCode());
                    currentMessage.setSendFlag("Y");
                    this.trySaveTransaction(currentMessage, obj);
                }
                catch (Exception e) {
                    this.saveFailMessageTransaction(currentMessage, obj, e);
                }
            }
        }
        catch (Exception e) {
            if (params != null) {
                params.put("ERROR_MESSAGE", e.getMessage());
            }
            for (Message message : userEmailToSend) {
                this.error(message, e.getMessage());
            }
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        if (params != null) {
            this.prepareSummary(userEmailToSend, params, success);
        }
    }

    private MailSender generateMailSender(Message message) {
        MailSender mailSender = (MailSender)this.beanFactory.getBean("mailSender");
        MessageEmailAccount messageEmailAccount = this.emailAccountMapper.selectByAccountCode(message.getMessageFrom());
        MessageEmailConfig config = this.configCache.getValue(messageEmailAccount.getConfigId().toString());
        if (null == config) {
            config = (MessageEmailConfig)this.emailConfigMapper.selectByPrimaryKey((Object)messageEmailAccount.getConfigId());
            config.setWhiteLists(this.emailWhiteListMapper.selectByConfigId(config.getConfigId()));
            config.setPropertyLists(this.emailPropertyMapper.selectByConfigId(config.getConfigId()));
        }
        mailSender.setHost(config.getHost());
        mailSender.setPort(Integer.parseInt(config.getPort()));
        mailSender.setMessageAccount(messageEmailAccount.getUserName());
        this.setAuthUserNameAndPassword(mailSender, messageEmailAccount, config);
        if ("Y".equalsIgnoreCase(config.getUseWhiteList())) {
            List whitelist = config.getWhiteLists();
            ArrayList<String> stringList = new ArrayList<String>();
            for (MessageEmailWhiteList current : whitelist) {
                stringList.add(current.getAddress());
            }
            mailSender.setWhiteList(stringList);
        }
        if (config.getPropertyLists() != null) {
            List propertyLists = config.getPropertyLists();
            Properties props = new Properties();
            for (MessageEmailProperty emailProperty : propertyLists) {
                props.put(emailProperty.getPropertyName(), emailProperty.getPropertyCode());
            }
            mailSender.setJavaMailProperties(props);
        }
        return mailSender;
    }

    private MimeMessage generateMimeMessage(Message currentMessage, List<File> fileList, List<MessageAttachment> attachments, MailSender mailSender) throws MessagingException, UnsupportedEncodingException {
        List receivers = this.receiverMapper.selectByMessageId(currentMessage.getMessageId());
        MimeMessage mimeMessage = mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
        helper.setFrom(mailSender.getMessageAccount());
        helper.setSubject(this.setEmailSubject(mailSender, currentMessage.getSubject()));
        if (CollectionUtils.isNotEmpty(fileList)) {
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)currentMessage.getContent(), "text/html; charset=UTF-8");
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messageBodyPart);
            for (File file : fileList) {
                messageBodyPart = new MimeBodyPart();
                FileDataSource fileDataSource = new FileDataSource(file);
                messageBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                messageBodyPart.setFileName(MimeUtility.encodeText((String)file.getName()));
                multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            mimeMessage.setContent((Multipart)multipart);
        } else {
            helper.setText(currentMessage.getContent(), true);
            if (CollectionUtils.isNotEmpty(attachments)) {
                ArrayList<String> attachmentIds = new ArrayList<String>();
                for (MessageAttachment attachment : attachments) {
                    attachmentIds.add(attachment.getFileId().toString());
                }
                List fileNames = this.sysFileService.selectByIds(null, attachmentIds);
                for (SysFile sysFile : fileNames) {
                    File file;
                    file = new File(sysFile.getFilePath());
                    if (!file.isFile()) continue;
                    helper.addAttachment(FilenameUtils.getName((String)sysFile.getFileName()), file);
                }
            }
        }
        for (MessageReceiver receiver : receivers) {
            if (receiver.getMessageAddress() == null || CollectionUtils.isNotEmpty((Collection)mailSender.getWhiteList()) && !mailSender.getWhiteList().contains(receiver.getMessageAddress())) continue;
            if (ReceiverTypeEnum.NORMAL.getCode().equalsIgnoreCase(receiver.getMessageType())) {
                helper.addTo(receiver.getMessageAddress());
                continue;
            }
            if (ReceiverTypeEnum.CC.getCode().equalsIgnoreCase(receiver.getMessageType())) {
                helper.addCc(receiver.getMessageAddress());
                continue;
            }
            if (!ReceiverTypeEnum.BCC.getCode().equalsIgnoreCase(receiver.getMessageType())) continue;
            helper.addBcc(receiver.getMessageAddress());
        }
        return mimeMessage;
    }

    private List<MessageAttachment> getMessageAttachments(Message message, String type) {
        List attachments = null;
        if (ATTACHMENT_SYSTEM.equals(type)) {
            attachments = this.attachmentMapper.selectByMessageId(message.getMessageId());
        }
        return attachments;
    }

    private MessageTransaction generateMessageTransaction(Message message) {
        MessageTransaction obj = new MessageTransaction();
        Date time = new Date();
        obj.setCreatedBy(Long.valueOf(-1L));
        obj.setLastUpdatedBy(Long.valueOf(-1L));
        obj.setCreationDate(time);
        obj.setLastUpdateDate(time);
        obj.setMessageId(message.getMessageId());
        obj.setObjectVersionNumber(Long.valueOf(0L));
        return obj;
    }

    private void saveFailMessageTransaction(Message currentMessage, MessageTransaction obj, Exception e) {
        obj.setTransactionMessage(this.getExceptionStack((Throwable)e));
        obj.setTransactionStatus(EmailStatusEnum.ERROR.getCode());
        currentMessage.setSendFlag("F");
        this.trySaveTransaction(currentMessage, obj);
        if (this.log.isErrorEnabled()) {
            this.log.error("Send mail failed.", (Throwable)e);
        }
    }

    private void prepareSummary(List<Message> messages, Map<String, Object> param, int success) {
        StringBuilder sb = new StringBuilder();
        if (messages.isEmpty()) {
            sb.append("No Email To Send.");
        } else {
            sb.append("Send ").append(messages.size()).append(" Emails. ");
            sb.append("  Success : ").append(success);
            Object object = param.get("ERROR_MESSAGE");
            if (object != null) {
                sb.append("  Error :  ").append(object);
            }
        }
        param.put("summary", sb.toString());
    }

    private void trySaveTransaction(Message message, MessageTransaction obj) {
        int dataBaseTryTime = 3;
        for (int i = 0; i < dataBaseTryTime; ++i) {
            try {
                ((IEmailService)this.self()).saveTransaction(message, obj);
                return;
            }
            catch (Exception e) {
                if (i != dataBaseTryTime - 1 || !this.log.isErrorEnabled()) continue;
                this.log.error("save transaction failed.", (Throwable)e);
                continue;
            }
        }
    }

    private String setEmailSubject(MailSender mailSender, String subject) {
        if (EnvironmentEnum.SIT.getCode().equals(mailSender.getEnvironment()) || EnvironmentEnum.UAT.getCode().equals(mailSender.getEnvironment())) {
            return "[" + mailSender.getEnvironment() + "] " + subject;
        }
        return subject;
    }

    private String getExceptionStack(Throwable th) {
        return ExceptionUtils.getStackTrace((Throwable)th);
    }
}

