/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.mail.ReceiverTypeEnum;
import com.hand.hap.mail.dto.Message;
import com.hand.hap.mail.dto.MessageReceiver;
import com.hand.hap.mail.dto.MessageTransaction;
import com.hand.hap.mail.mapper.MessageReceiverMapper;
import com.hand.hap.mail.mapper.MessageTransactionMapper;
import com.hand.hap.mail.service.IMessageService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/message", "/api/sys/message"})
public class MessageController
extends BaseController {
    @Autowired
    private IMessageService messageService;
    @Autowired
    private MessageTransactionMapper messageTransactionMapper;
    @Autowired
    private MessageReceiverMapper messageReceiverMapper;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData getMessageBySubject(HttpServletRequest request, Message message, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.messageService.selectMessages(requestContext, message, page, pagesize));
    }

    @RequestMapping(value={"/queryMessageAddresses"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData getMessageAddressesByMessageId(HttpServletRequest request, MessageReceiver messageReceiver, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.messageService.selectMessageAddressesByMessageId(requestContext, messageReceiver, page, pagesize));
    }

    @RequestMapping(value={"/sendTest"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData sendTestMessage(HttpServletRequest request, @RequestBody Map<String, Object> param) throws Exception {
        IRequest iRequest = this.createRequestContext(request);
        String str = param.get("receivers").toString();
        String[] receivers = StringUtils.split((String)str, (String)";");
        ArrayList<MessageReceiver> receiverList = new ArrayList<MessageReceiver>();
        for (String r : receivers) {
            MessageReceiver mr = new MessageReceiver();
            mr.setMessageAddress(r);
            mr.setMessageType(ReceiverTypeEnum.NORMAL.getCode());
            receiverList.add(mr);
        }
        List attachments = (List)param.get("attachments");
        ArrayList<Long> attachment = null;
        if (null != attachments) {
            attachment = new ArrayList<Long>();
            for (Integer s : attachments) {
                attachment.add(Long.valueOf(s.intValue()));
            }
        }
        if ("template".equals(param.get("mode"))) {
            if (param.get("accountCode") != null && StringUtils.isNotEmpty((String)param.get("accountCode").toString())) {
                this.messageService.addEmailMessage(iRequest.getUserId(), param.get("accountCode").toString(), param.get("templateCode").toString(), null, attachment, receiverList);
            } else {
                this.messageService.sendMessage(iRequest, param.get("templateCode").toString(), null, receiverList, attachment);
            }
        }
        return new ResponseData();
    }

    @RequestMapping(value={"/error_mess"}, method={RequestMethod.GET, RequestMethod.POST})
    public String errorMess(Long messageId) {
        MessageTransaction messageTransaction = new MessageTransaction();
        messageTransaction.setMessageId(messageId);
        List mess = this.messageTransactionMapper.select((Object)messageTransaction);
        String result = ((MessageTransaction)mess.get(mess.size() - 1)).getTransactionMessage();
        return result;
    }

    @RequestMapping(value={"/messageContent"}, method={RequestMethod.GET, RequestMethod.POST})
    public String messageContent(HttpServletRequest request, Long messageId) {
        IRequest iRequest = this.createRequestContext(request);
        Message message = new Message();
        message.setMessageId(messageId);
        Message msg = this.messageService.selectMessageContent(iRequest, message);
        return msg.getContent();
    }

    @RequestMapping(value={"/messageReceiver"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData messageReceiver(HttpServletRequest request, Long messageId) {
        return new ResponseData(this.messageReceiverMapper.selectByMessageId(messageId));
    }
}

