/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.job.examples;

import com.hand.hap.job.AbstractJob;
import java.util.Date;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRecoveryJob
extends AbstractJob {
    private static Logger log = LoggerFactory.getLogger(SimpleRecoveryJob.class);
    private static final String COUNT = "count";

    public void safeExecute(JobExecutionContext context) throws Exception {
        JobKey jobKey = context.getJobDetail().getKey();
        if (context.isRecovering()) {
            log.info("SimpleRecoveryJob: " + jobKey + " RECOVERING at " + new Date());
        } else {
            log.info("SimpleRecoveryJob: " + jobKey + " starting at " + new Date());
        }
        long delay = 10000L;
        try {
            Thread.sleep(delay);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JobDataMap data = context.getJobDetail().getJobDataMap();
        int count = data.containsKey((Object)COUNT) ? data.getInt(COUNT) : 0;
        data.put(COUNT, ++count);
        log.info("SimpleRecoveryJob: " + jobKey + " done at " + new Date() + "\n Execution #" + count);
    }

    public boolean isRefireImmediatelyWhenException() {
        return false;
    }
}

