/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.util;

import com.google.common.base.Throwables;
import com.hand.hap.core.components.UserLoginInfoCollection;
import com.hand.hap.intergration.beans.HapinterfaceBound;
import com.hand.hap.intergration.controllers.HapInvokeRequestBodyAdvice;
import com.hand.hap.intergration.dto.HapInterfaceInbound;
import com.hand.hap.intergration.dto.HapInterfaceOutbound;
import com.hand.hap.message.IMessagePublisher;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.message.Message;

/*
 * Exception performing whole class analysis ignored.
 */
public class HapInvokeLogUtils {
    public static String getRootCauseStackTrace(Throwable throwable) {
        Throwable t = Throwables.getRootCause((Throwable)throwable);
        String stackTrace = Throwables.getStackTraceAsString((Throwable)t);
        return stackTrace;
    }

    public static void processRequestInfo(HapInterfaceInbound inbound, HttpServletRequest request) {
        inbound.setUserAgent(request.getHeader("User-Agent"));
        if (inbound.getRequestMethod() == null) {
            inbound.setRequestMethod(request.getMethod());
        }
        if (inbound.getInterfaceUrl() == null) {
            inbound.setInterfaceUrl(request.getServletPath());
        }
        if (inbound.getRequestHeaderParameter() == null) {
            inbound.setRequestHeaderParameter(request.getQueryString());
        }
        if (inbound.getRequestBodyParameter() == null) {
            inbound.setRequestBodyParameter(HapInvokeRequestBodyAdvice.getAndRemoveBody());
        }
        inbound.setIp(UserLoginInfoCollection.getIpAddress((HttpServletRequest)request));
    }

    public static void processExceptionInfo(HapInterfaceInbound inbound, Throwable throwable) {
        if (throwable != null) {
            inbound.setStackTrace(HapInvokeLogUtils.getRootCauseStackTrace((Throwable)throwable));
            inbound.setRequestStatus("failure");
        }
    }

    public static void processExceptionInfo(HapInterfaceOutbound outbound, Throwable throwable) {
        if (throwable != null) {
            outbound.setStackTrace(HapInvokeLogUtils.getRootCauseStackTrace((Throwable)throwable));
            outbound.setRequestStatus("failure");
        }
    }

    public static void processCxfHandleFault(Message message, IMessagePublisher messagePublisher) {
        HapInterfaceOutbound outbound = (HapInterfaceOutbound)message.getExchange().get((Object)"HAP_OUTBOUND");
        HapInterfaceInbound inbound = (HapInterfaceInbound)message.getExchange().get((Object)"HAP_INBOUND");
        Exception fault = (Exception)message.getContent(Exception.class);
        if (inbound != null) {
            inbound.setRequestStatus("failure");
            inbound.setResponseTime(Long.valueOf(System.currentTimeMillis() - inbound.getRequestTime().getTime()));
            HapInvokeLogUtils.processExceptionInfo((HapInterfaceInbound)inbound, (Throwable)fault);
            messagePublisher.message("invoke.inbound", (Object)new HapinterfaceBound(inbound));
        } else if (outbound != null) {
            HapInvokeLogUtils.processExceptionInfo((HapInterfaceOutbound)outbound, (Throwable)fault);
            outbound.setResponseTime(Long.valueOf(System.currentTimeMillis() - outbound.getRequestTime().getTime()));
            messagePublisher.message("invoke.outbound", (Object)new HapinterfaceBound(outbound));
        }
    }
}

