/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.components;

import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.InvokeLogStrategy;
import com.hand.hap.intergration.dto.HapInterfaceInbound;
import com.hand.hap.intergration.dto.HapInterfaceOutbound;
import com.hand.hap.intergration.service.IHapInterfaceInboundService;
import com.hand.hap.intergration.service.IHapInterfaceOutboundService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultInvokeLogStrategy
implements InvokeLogStrategy {
    @Autowired
    private IHapInterfaceInboundService inboundService;
    @Autowired
    private IHapInterfaceOutboundService outboundService;

    public void logInbound(HapInterfaceInbound inbound) {
        this.inboundService.inboundInvoke(inbound);
    }

    public void logOutbound(HapInterfaceOutbound outbound) {
        this.outboundService.outboundInvoke(outbound);
    }

    public List<HapInterfaceInbound> queryInbound(IRequest request, HapInterfaceInbound condition, int pageNum, int pageSize) {
        return this.inboundService.select(request, (Object)condition, pageNum, pageSize);
    }

    public List<HapInterfaceOutbound> queryOutbound(IRequest request, HapInterfaceOutbound condition, int pageNum, int pageSize) {
        return this.outboundService.select(request, (Object)condition, pageNum, pageSize);
    }
}

