/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.hr.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.hr.dto.Position;
import com.hand.hap.hr.service.IPositionService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.WhereField;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hr/position", "/api/hr/position"})
public class PositionController
extends BaseController {
    @Autowired
    private IPositionService positionService;

    @RequestMapping(value={"/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData getPosition(HttpServletRequest request, Position position, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest iRequest = this.createRequestContext(request);
        Criteria criteria = new Criteria((Object)position);
        criteria.where(new Object[]{new WhereField("positionCode", Comparison.LIKE), "positionId", "name", "parentPositionId"});
        return new ResponseData(this.positionService.selectOptions(iRequest, (Object)position, criteria, Integer.valueOf(page), Integer.valueOf(pagesize)));
    }

    @PostMapping(value={"/submit"})
    public ResponseData submitPosition(@RequestBody List<Position> positions, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(positions, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.positionService.batchUpdate(requestCtx, positions));
    }

    @PostMapping(value={"/remove"})
    public ResponseData delete(HttpServletRequest request, @RequestBody List<Position> positions) {
        this.positionService.batchDelete(positions);
        return new ResponseData();
    }
}

