/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.service.impl;

import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.function.dto.Function;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.mapper.FunctionResourceMapper;
import com.hand.hap.function.mapper.ResourceMapper;
import com.hand.hap.function.service.IResourceCustomizationService;
import com.hand.hap.function.service.IResourceItemService;
import com.hand.hap.function.service.IResourceService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import net.logstash.logback.encoder.org.apache.commons.lang.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourceServiceImpl
extends BaseServiceImpl<Resource>
implements IResourceService {
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private FunctionResourceMapper functionResourceMapper;
    @Autowired
    private IResourceItemService resourceItemService;
    @Autowired
    private IResourceCustomizationService resourceCustomizationService;

    @Transactional(propagation=Propagation.SUPPORTS)
    public Resource selectResourceByUrl(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        Cache cache = this.getResourceByURL();
        Resource resource = (Resource)cache.getValue(url);
        if (resource == null) {
            resource = this.resourceMapper.selectResourceByUrl(url);
            this.flushCache(resource);
        }
        return resource;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public Resource selectResourceById(Long id) {
        if (id == null) {
            return null;
        }
        Cache cache = this.getResourceById();
        Resource resource = (Resource)cache.getValue(id.toString());
        if (resource == null) {
            resource = (Resource)this.resourceMapper.selectByPrimaryKey((Object)id);
            this.flushCache(resource);
        }
        return resource;
    }

    @Transactional(rollbackFor={Exception.class})
    public Resource insertSelective(IRequest request, Resource resource) {
        String url = resource.getUrl();
        if (url.startsWith("/")) {
            resource.setUrl(url.substring(1));
        }
        this.resourceMapper.insertSelective((Object)resource);
        this.flushCache(resource);
        return resource;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<Resource> batchUpdate(IRequest requestContext, List<Resource> resources) {
        for (Resource resource : resources) {
            if (resource.getResourceId() != null) {
                ((IResourceService)this.self()).updateByPrimaryKeySelective(requestContext, (Object)resource);
                continue;
            }
            ((IResourceService)this.self()).insertSelective(requestContext, (Object)resource);
        }
        return resources;
    }

    @Transactional(rollbackFor={Exception.class})
    public Resource updateByPrimaryKeySelective(IRequest request, @StdWho Resource record) {
        String url = record.getUrl();
        if (url.startsWith("/")) {
            record.setUrl(url.substring(1));
        }
        record = (Resource)super.updateByPrimaryKeySelective(request, (Object)record);
        this.flushCache(record);
        this.reloadFunction();
        return record;
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteByPrimaryKey(Resource resource) {
        if (resource == null || resource.getResourceId() == null || StringUtils.isEmpty((String)resource.getUrl())) {
            return 0;
        }
        int updateCount = this.resourceMapper.deleteByPrimaryKey((Object)resource);
        this.checkOvn(updateCount, (Object)resource);
        this.functionResourceMapper.deleteByResource(resource);
        this.resourceItemService.deleteByResourceId(resource);
        this.resourceCustomizationService.deleteByResourceId(resource.getResourceId());
        this.removeCache(resource);
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public int batchDelete(IRequest requestContext, List<Resource> resources) {
        int result = 0;
        if (CollectionUtils.isEmpty(resources)) {
            return result;
        }
        for (Resource resource : resources) {
            ((IResourceService)this.self()).deleteByPrimaryKey((Object)resource);
            ++result;
        }
        return result;
    }

    private Cache<Resource> getResourceByURL() {
        return this.cacheManager.getCache("resource_url");
    }

    private Cache<Resource> getResourceById() {
        return this.cacheManager.getCache("resource_id");
    }

    private Cache<Function> getFunction() {
        return this.cacheManager.getCache("function");
    }

    private void flushCache(Resource resource) {
        if (resource == null) {
            return;
        }
        Cache resourceCache = this.getResourceByURL();
        resourceCache.setValue(resource.getUrl(), (Object)resource);
        Cache resourceCache2 = this.getResourceById();
        resourceCache2.setValue(resource.getResourceId().toString(), (Object)resource);
    }

    private void removeCache(Resource resource) {
        if (resource == null) {
            return;
        }
        Cache resourceCache = this.getResourceByURL();
        resourceCache.remove(resource.getUrl());
        Cache resourceCache2 = this.getResourceById();
        resourceCache2.remove(resource.getResourceId().toString());
        this.reloadFunction();
    }

    private void reloadFunction() {
        Cache functionCache = this.getFunction();
        functionCache.reload();
    }
}

