/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.flexfield.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.flexfield.dto.FlexModelColumn;
import com.hand.hap.flexfield.service.IFlexModelColumnService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fnd/flex", "/api/fnd/flex"})
public class FlexModelColumnController
extends BaseController {
    @Autowired
    private IFlexModelColumnService service;

    @RequestMapping(value={"/model/column/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData query(FlexModelColumn dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.selectOptions(requestContext, (Object)dto, null, Integer.valueOf(page), Integer.valueOf(pageSize)));
    }

    @PostMapping(value={"/model/column/submit"})
    public ResponseData update(@RequestBody List<FlexModelColumn> dto, HttpServletRequest request, BindingResult result) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @PostMapping(value={"/model/column/remove"})
    public ResponseData delete(HttpServletRequest request, @RequestBody List<FlexModelColumn> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/column/queryAll"}, method={RequestMethod.GET, RequestMethod.POST})
    public ResponseData getTableColumn(HttpServletRequest request, String tableName) {
        return new ResponseData(this.service.getTableColumn(tableName));
    }
}

