/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.excel.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hand.hap.core.components.ApplicationContextHelper;
import com.hand.hap.excel.ExcelException;
import com.hand.hap.excel.annotation.ExcelExport;
import com.hand.hap.excel.service.IHapExcelExportService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class HapExcelExportAspect {
    @AfterReturning(value="@annotation(excelExport)", returning="responseData")
    public void afterController(JoinPoint joinpoint, ExcelExport excelExport, Object responseData) throws IOException, SQLException, ExcelException {
        HttpServletRequest httpServletRequest = null;
        HttpServletResponse httpServletResponse = null;
        for (int i = 0; i < joinpoint.getArgs().length; ++i) {
            if (joinpoint.getArgs()[i] instanceof HttpServletRequest) {
                httpServletRequest = (HttpServletRequest)joinpoint.getArgs()[i];
                continue;
            }
            if (!(joinpoint.getArgs()[i] instanceof HttpServletResponse)) continue;
            httpServletResponse = (HttpServletResponse)joinpoint.getArgs()[i];
        }
        if (httpServletRequest.getParameterMap().containsKey("_HAP_EXCEL_EXPORT_COLUMNS")) {
            String columnsJson = ((String[])httpServletRequest.getParameterMap().get("_HAP_EXCEL_EXPORT_COLUMNS"))[0];
            ObjectMapper mapper = new ObjectMapper();
            ArrayNode node = (ArrayNode)mapper.readValue(columnsJson, ArrayNode.class);
            ArrayList columns = new ArrayList();
            node.forEach(v -> columns.add(v.get("column").asText()));
            ((IHapExcelExportService)ApplicationContextHelper.getApplicationContext().getBean(IHapExcelExportService.class)).exportAndDownloadExcel(responseData, httpServletRequest, httpServletResponse, columns);
        }
    }
}

