/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.xpath;

import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.xpath.Predicate;
import com.hand.hap.core.web.view.xpath.XPathPredicate;
import com.hand.hap.core.web.view.xpath.XPathRequest;
import org.apache.commons.lang3.StringUtils;

public class XPathStep {
    private static final String COLON = ":";
    private XPathRequest request;
    private String nodeName;
    private String namespce;
    private Predicate predicate;

    public String getNodeName() {
        return this.nodeName;
    }

    public XPathStep(String value, XPathRequest request) {
        this.request = request;
        int elementEnd = this.getElementEnd(value);
        this.parseNodeName(value.substring(0, elementEnd));
        if (elementEnd != value.length()) {
            this.predicate = XPathPredicate.build((String)value.substring(elementEnd));
        }
    }

    private void parseNodeName(String name) {
        if (StringUtils.contains((CharSequence)name, (CharSequence)COLON)) {
            this.nodeName = StringUtils.substringAfter((String)name, (String)COLON);
            String prefix = StringUtils.substringBefore((String)name, (String)COLON);
            this.namespce = this.request.getNamespace(prefix);
        } else {
            this.nodeName = name;
        }
    }

    private int getElementEnd(String value) {
        int bIndex = value.indexOf(91);
        return bIndex > 0 ? bIndex : value.length();
    }

    public boolean validate(XMap node) {
        return this.validateName(node) && this.validatePredicate(node);
    }

    private boolean validateName(XMap node) {
        return node == null && StringUtils.isEmpty((CharSequence)this.nodeName) || node.getName().equals(this.nodeName) && node.getNamespaceURI().equals(this.namespce);
    }

    private boolean validatePredicate(XMap node) {
        if (this.predicate != null && node != null) {
            return this.predicate.validate(node);
        }
        return true;
    }
}

