/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view;

import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.XMapUtil;
import com.hand.hap.core.web.view.xpath.XPathRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * Exception performing whole class analysis ignored.
 */
public class XMapUtil {
    public static final String ANY_VALUE = "*";
    public static final String NULL_VALUE = "null";
    public static final String MERGE_ACTION = "action";
    public static final String MERGE_ACTION_AFTER = "after";
    public static final String MERGE_ACTION_BEFORE = "before";
    public static final String MERGE_ACTION_REPLACE = "replace";
    public static final String MERGE_ACTION_REMOVE = "remove";
    public static final String MERGE_ACTION_ATTRIBUTE = "attribute";

    public static List<XMap> findByName(XMap root, String nodeName) {
        if (root == null) {
            return null;
        }
        NameFinder cf = new NameFinder(nodeName);
        return cf.find(root);
    }

    public static void merge(XMap source, XMap dest) {
        List list = XMapUtil.findByName((XMap)dest, (String)"xpath");
        for (XMap xpath : list) {
            String action = xpath.getString((Object)"action");
            String express = xpath.getString((Object)"expr");
            XPathRequest request = new XPathRequest(express, xpath.getNamespaceMapping());
            XPathFinder cf = new XPathFinder(request);
            XMap result = cf.find(source);
            if (result == null) continue;
            AtomicInteger index = new AtomicInteger(result.getParent().getChildren().indexOf(result));
            if ("remove".equalsIgnoreCase(action)) {
                result.getParent().removeChild(result);
                continue;
            }
            if ("attribute".equalsIgnoreCase(action)) {
                xpath.getChildren().forEach(child -> result.put((Object)child.getString((Object)"name"), (Object)child.getString((Object)"value")));
                continue;
            }
            if ("replace".equalsIgnoreCase(action)) {
                result.getParent().remove((Object)result);
                xpath.getChildren().forEach(child -> result.getParent().addChild(index.incrementAndGet(), child));
                continue;
            }
            xpath.getChildren().forEach(child -> {
                if ("after".equalsIgnoreCase(action)) {
                    result.getParent().addChild(index.incrementAndGet(), child);
                } else if ("before".equalsIgnoreCase(action)) {
                    int i = index.get();
                    result.getParent().addChild(i >= 0 ? i : 0, child);
                }
            });
        }
    }

    public static boolean compare(Object field, String value) {
        if (field == null) {
            if (value == null) {
                return true;
            }
            return "null".equals(value);
        }
        if ("*".equals(value)) {
            return true;
        }
        return field.toString().equals(value);
    }

    public static XMap findParentWithName(XMap map, String element_name) {
        for (XMap parent = map.getParent(); parent != null; parent = parent.getParent()) {
            if (element_name == null || !element_name.equals(parent.getName())) continue;
            return parent;
        }
        return null;
    }

    private static String getKey(XMap map, Object[] keys) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            buf.append(map.get(keys[i]));
        }
        return buf.toString();
    }

    public static void join(Collection list1, Collection list2, Object[] key_fields) {
        String key;
        HashMap<String, XMap> join_index = new HashMap<String, XMap>();
        for (XMap item : list1) {
            key = XMapUtil.getKey((XMap)item, (Object[])key_fields);
            join_index.put(key, item);
        }
        for (XMap source : list2) {
            key = XMapUtil.getKey((XMap)source, (Object[])key_fields);
            XMap target = (XMap)join_index.get(key);
            if (target == null) continue;
            target.putAll((Map)source);
        }
        join_index.clear();
    }

    public static XMap collapse(XMap root) {
        List childs = root.getChildren();
        if (childs == null) {
            return root;
        }
        ListIterator it = childs.listIterator();
        while (it.hasNext()) {
            XMap child = (XMap)it.next();
            String text = child.getText();
            if (child.size() == 0 && text != null && !"".equals(text.trim())) {
                root.put((Object)child.getName(), (Object)text);
                it.remove();
                continue;
            }
            XMapUtil.collapse((XMap)child);
        }
        return root;
    }

    public static XMap expand(XMap root) {
        List childs = root.getChildren();
        if (childs != null) {
            ListIterator it = childs.listIterator();
            while (it.hasNext()) {
                XMap child = (XMap)it.next();
                XMapUtil.expand((XMap)child);
            }
        }
        Set keyset = root.keySet();
        Iterator it = keyset.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            XMap keychild = new XMap(key);
            keychild.setText(root.getString((Object)key));
            root.addChild(keychild);
        }
        HashSet hs = new HashSet();
        hs.addAll(keyset);
        for (Object key : hs) {
            root.remove(key);
        }
        return root;
    }

    public static void fillMap(Map target, XMap data, Object key_field) {
        Iterator it = data.getChildIterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            XMap item = (XMap)it.next();
            Object key = item.get(key_field);
            target.put(key, item);
        }
    }

    public static void fillMap(Map target, XMap data, Object key_field, Object value_field) {
        Iterator it = data.getChildIterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            XMap item = (XMap)it.next();
            Object key = item.get(key_field);
            Object value = item.get(value_field);
            target.put(key, value);
        }
    }

    public static String connectAttribute(XMap root, String attrib_name, String separator) {
        if (root == null) {
            return null;
        }
        Iterator it = root.getChildIterator();
        if (it == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int id = 0;
        while (it.hasNext()) {
            XMap child = (XMap)it.next();
            Object value = child.get((Object)attrib_name);
            if (id > 0) {
                result.append(separator);
            }
            result.append(value);
            ++id;
        }
        return result.toString();
    }

    public static String connectAttribute(XMap root, String attrib_name) {
        return XMapUtil.connectAttribute((XMap)root, (String)attrib_name, (String)",");
    }

    public static void copyAttributes(Map source, Map dest) {
        for (Map.Entry entry : source.entrySet()) {
            if (dest.containsKey(entry.getKey())) continue;
            dest.put(entry.getKey(), entry.getValue());
        }
    }

    public static void mergeChildsByOverride(XMap source, XMap dest, Object key) {
        Iterator it = source.getChildIterator();
        if (it == null) {
            return;
        }
        HashMap dest_cache = new HashMap();
        XMapUtil.fillMap(dest_cache, (XMap)dest, (Object)key);
        while (it.hasNext()) {
            XMap source_item = (XMap)it.next();
            Object value = source_item.get(key);
            XMap dest_item = (XMap)dest_cache.get(value);
            if (dest_item != null) {
                XMapUtil.copyAttributes((Map)source_item, (Map)dest_item);
                continue;
            }
            dest.addChild((XMap)source_item.clone());
        }
        dest_cache.clear();
    }

    public static void mergeChildsByReference(XMap source, XMap dest, Object key) {
        Iterator it = dest.getChildIterator();
        if (it == null) {
            return;
        }
        HashMap source_cache = new HashMap();
        XMapUtil.fillMap(source_cache, (XMap)source, (Object)key);
        while (it.hasNext()) {
            XMap dest_item = (XMap)it.next();
            Object value = dest_item.get(key);
            XMap source_item = (XMap)source_cache.get(value);
            if (source_item == null) continue;
            XMapUtil.copyAttributes((Map)source_item, (Map)dest_item);
        }
        source_cache.clear();
    }

    public static void getLevelChilds(XMap source, int level, List result) {
        if (source == null) {
            return;
        }
        if (level == 0) {
            result.add(source);
        }
        if (source.getChildren() == null) {
            return;
        }
        if (level == 1) {
            result.addAll(source.getChildren());
        } else if (level > 1) {
            Iterator it = source.getChildIterator();
            while (it.hasNext()) {
                XMapUtil.getLevelChilds((XMap)((XMap)it.next()), (int)(level - 1), (List)result);
            }
        }
    }
}

