/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view;

import com.hand.hap.core.web.view.ScreenHandler;
import com.hand.hap.core.web.view.XMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMapHandler
implements ScreenHandler {
    private XMap current = null;
    private Map<String, String> uriMapping = new HashMap();
    private LinkedList<XMap> stack = new LinkedList();
    int[] holderForStartAndLength = new int[2];

    public void processDocument(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int eventType = xpp.getEventType();
        do {
            if (eventType == 0) {
                this.startDocument();
                continue;
            }
            if (eventType == 2) {
                this.processStartElement(xpp);
                continue;
            }
            if (eventType == 3) {
                this.processEndElement(xpp);
                continue;
            }
            if (eventType != 4 && eventType != 5) continue;
            this.processText(xpp);
        } while ((eventType = xpp.nextToken()) != 1);
    }

    public XMap getRoot() {
        return this.current;
    }

    public void startDocument() {
        this.current = null;
        this.uriMapping.clear();
        this.stack.clear();
    }

    public void endElement() {
        if (this.stack.size() > 0) {
            this.current = this.pop();
        }
    }

    private XMap pop() {
        XMap node = (XMap)this.stack.getFirst();
        this.stack.removeFirst();
        return node;
    }

    private void setAttribs(XMap node, XmlPullParser xpp) {
        int count = xpp.getAttributeCount();
        int l = count;
        for (int i = 0; i < l; ++i) {
            String attrib_name = xpp.getAttributeName(i);
            node.put((Object)attrib_name, (Object)xpp.getAttributeValue(i));
        }
    }

    private void push(XMap node) {
        this.stack.addFirst(node);
    }

    public void processStartElement(XmlPullParser xpp) throws IOException, XmlPullParserException {
        String name = xpp.getName();
        String namespace = xpp.getNamespace();
        String prefix = xpp.getPrefix();
        prefix = prefix == null ? ("http://www.hand-china.com/hap".equals(namespace) ? "h" : "") : prefix;
        this.uriMapping.put(prefix, namespace);
        XMap node = new XMap(prefix, namespace, name);
        node.setNamespaceMapping(this.uriMapping);
        this.setAttribs(node, xpp);
        if (this.current == null) {
            this.current = node;
        } else {
            this.current.addChild(node);
            this.push(this.current);
            this.current = node;
        }
    }

    public void processEndElement(XmlPullParser xpp) {
        this.endElement();
    }

    public void processText(XmlPullParser xpp) throws XmlPullParserException {
        char[] ch = xpp.getTextCharacters(this.holderForStartAndLength);
        int start = this.holderForStartAndLength[0];
        int length = this.holderForStartAndLength[1];
        if (ch == null) {
            return;
        }
        if (start == length) {
            return;
        }
        if (this.current != null) {
            String t = this.current.getText();
            t = t != null ? t + new String(ch, start, length) : new String(ch, start, length);
            this.current.setText(t);
        }
    }
}

